﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.ToolDevelopmentKit
{
    /// <summary>
    /// クローン関連のユーティリティです。
    /// </summary>
    public static class SettableUtility
    {
        /// <summary>
        /// ISettable オブジェクトを設定します。
        /// </summary>
        /// <param name="source">設定元オブジェクトです。</param>
        /// <param name="destination">設定先オブジェクトです。</param>
        /// <returns>オブジェクトが nullの場合は設定を行わず false を返します。</returns>
        public static bool TrySet(ISettable source, ISettable destination)
        {
            if (destination == null || source == null)
            {
                return false;
            }

            destination.Set(source);
            return true;
        }
    }
}
