﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.ToolDevelopmentKit
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// 等価比較をおこなうコンペアラです。
    /// </summary>
    /// <typeparam name="T">比較するオブジェクトの型です。</typeparam>
    public class ReferenceEqualityComparer<T> : IEqualityComparer<T>
    {
        /// <summary>
        /// 指定したオブジェクトが等しいかどうかを判断します。
        /// </summary>
        /// <param name="x">比較対象の T 型の第 1 オブジェクトです。</param>
        /// <param name="y">比較対象の T 型の第 2 オブジェクトです。</param>
        /// <returns>指定したオブジェクトが等しい場合は true、それ以外の場合は false を返します。</returns>
        public bool Equals(T x, T y)
        {
            return Object.ReferenceEquals(x, y);
        }

        /// <summary>
        /// 指定したオブジェクトのハッシュ コードを返します。
        /// </summary>
        /// <param name="obj">ハッシュ コードが返される対象の Object です。</param>
        /// <returns>指定したオブジェクトのハッシュ コードです。</returns>
        public int GetHashCode(T obj)
        {
            return obj.GetHashCode();
        }
    }
}
