﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.ToolDevelopmentKit
{
    using System;

    /// <summary>
    /// 数学計算のユーティリティです。
    /// </summary>
    public class MathUtility
    {
        /// <summary>
        /// degree から radian に変換します。
        /// </summary>
        /// <param name="degrees">度数法で表された角度です。</param>
        /// <returns>弧度法で表された角度です。</returns>
        public static float ConvertDegreeToRadians(float degrees)
        {
            return ((float)Math.PI / 180.0f) * degrees;
        }

        /// <summary>
        /// radian から degree に変換します。
        /// </summary>
        /// <param name="radian">弧度法で表された角度です。</param>
        /// <returns>度数法で表された角度です。</returns>
        public static float ConvertRadianToDegrees(float radian)
        {
            return (180.0f / (float)Math.PI) * radian;
        }

        /// <summary>
        /// Vector3 を degree から radian に変換します。
        /// </summary>
        /// <param name="degrees">度数法で表された角度です。</param>
        /// <returns>弧度法で表された角度です。</returns>
        public static Vector3 ConvertDegreeToRadians(Vector3 degrees)
        {
            Vector3 radians = new Vector3();

            radians.X = ConvertDegreeToRadians(degrees.X);
            radians.Y = ConvertDegreeToRadians(degrees.Y);
            radians.Z = ConvertDegreeToRadians(degrees.Z);

            return radians;
        }

        /// <summary>
        /// Vector3 を radian から degree に変換します。
        /// </summary>
        /// <param name="radians">弧度法で表された角度です。</param>
        /// <returns>度数法で表された角度です。</returns>
        public static Vector3 ConvertRadianToDegrees(Vector3 radians)
        {
            Vector3 degrees = new Vector3();

            degrees.X = ConvertRadianToDegrees(radians.X);
            degrees.Y = ConvertRadianToDegrees(radians.Y);
            degrees.Z = ConvertRadianToDegrees(radians.Z);

            return radians;
        }
    }
}
