﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.ToolDevelopmentKit
{
    /// <summary>
    /// クラスの等値比較を支援するクラスです。
    /// </summary>
    /// <typeparam name="T">判定する対象の型です。</typeparam>
    public static class CheckClassEqualityUtil<T>
        where T : class
    {
        /// <summary>
        /// クラス型固有の等値比較をするデリゲートです。
        /// </summary>
        /// <param name="obj">判定する対象のインスタンスです。</param>
        /// <returns>等値比較結果です。</returns>
        public delegate bool TypeEquals(T obj);

        /// <summary>
        /// 基本的な等値比較を行います。
        /// </summary>
        /// <param name="selfObj">比較されるインスタンスです。</param>
        /// <param name="otherObj">object型で比較されるインスタンスです。</param>
        /// <param name="typeEqualsFunc">クラス型固有の等値比較をするデリゲートです。</param>
        /// <returns>等値比較結果です。</returns>
        public static bool Equals(T selfObj, object otherObj, TypeEquals typeEqualsFunc)
        {
            Ensure.Argument.NotNull(typeEqualsFunc);

            if ((selfObj as object) == otherObj)
            {
                return true;
            }

            if ((selfObj == null) ||
                (otherObj == null) ||
                (selfObj.GetType() != otherObj.GetType()))
            {
                return false;
            }

            return typeEqualsFunc(otherObj as T);
        }
    }
}
