﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.ToolDevelopmentKit.Xml
{
    using System.Xml.Serialization;
    using NintendoWare.ToolDevelopmentKit.Conversion;

    /// <summary>
    /// RGBA 成分を保持するカラーです。
    /// </summary>
    [CoupledType(typeof(RgbaColor))]
    [XmlType("RgbaColor")]
    public sealed class RgbaColorXml : ISettable
    {
        /// <summary>
        /// R 成分を取得または設定します。
        /// </summary>
        [XmlElement("r")]
        public float R { get; set; }

        /// <summary>
        /// G 成分を取得または設定します。
        /// </summary>
        [XmlElement("g")]
        public float G { get; set; }

        /// <summary>
        /// B 成分を取得または設定します。
        /// </summary>
        [XmlElement("b")]
        public float B { get; set; }

        /// <summary>
        /// A 成分を取得または設定します。
        /// </summary>
        [XmlElement("a")]
        public float A { get; set; }

        /// <summary>
        /// H 成分を取得します。
        /// </summary>
        [XmlIgnore]
        [ConversionIgnore]
        public float H { get; set; }

        /// <summary>
        /// S 成分を取得します。
        /// </summary>
        [XmlIgnore]
        [ConversionIgnore]
        public float S { get; set; }

        /// <summary>
        /// V 成分を取得します。
        /// </summary>
        [XmlIgnore]
        [ConversionIgnore]
        public float V { get; set; }

        /// <summary>
        /// オブジェクトを設定します。
        /// </summary>
        /// <param name="source">設定するオブジェクトです。</param>
        public void Set(object source)
        {
            Ensure.Argument.True(source is RgbaColorXml);

            RgbaColorXml srcColor = source as RgbaColorXml;
            this.R = srcColor.R;
            this.G = srcColor.G;
            this.B = srcColor.B;
            this.A = srcColor.A;
        }
    }
}
