﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.ToolDevelopmentKit.Xml
{
    using System;
    using System.Collections.Generic;
    using System.Text.RegularExpressions;
    using System.Threading;
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// Xmlシリアライズ用ユーティリティクラスです。
    /// </summary>
    public static class XmlSerializeUtility
    {
        /// <summary>
        /// 空白文字列です。
        /// </summary>
        public const string BlankChar = " ";

        /// <summary>
        /// 行列形式のテキスト文字列を整形します。
        /// </summary>
        /// <param name="arrayText">テキスト文字列</param>
        /// <returns>整形された文字列です。</returns>
        public static string CleanupArrayText(string arrayText)
        {
            Ensure.Argument.StringNotEmpty(arrayText);

            arrayText = arrayText.Replace("\r", string.Empty);
            arrayText = arrayText.Replace("\n", BlankChar);
            arrayText = arrayText.Replace("\t", string.Empty);
            arrayText = arrayText.Trim();
            arrayText = Regex.Replace(arrayText, " +", BlankChar);

            return arrayText;
        }

        /// <summary>
        /// 値列の文字列からコレクションを設定します。
        /// </summary>
        /// <typeparam name="TValue">コレクションの型です。</typeparam>
        /// <param name="sourceString">文字列です。</param>
        /// <param name="dstCollection">コレクションです。</param>
        /// <param name="reserveHandler">コレクションの要素を確保する処理ハンドラです。</param>
        public static void SetCollectionByString<TValue>(
            string sourceString,
            IList<TValue> dstCollection,
            Func<int, IList<TValue>> reserveHandler)
        {
            sourceString = XmlSerializeUtility.CleanupArrayText(sourceString);
            string[] elementTextSet = sourceString.Split(" ".ToCharArray());

            dstCollection = reserveHandler(elementTextSet.Length);

            IFormatProvider formatProvider = Thread.CurrentThread.CurrentUICulture;
            Type elementType = typeof(TValue);
            for (int i = 0; i < elementTextSet.Length; i++)
            {
                dstCollection[i] = (TValue)Convert.ChangeType(
                    elementTextSet[i],
                    elementType,
                    formatProvider);
            }
        }
    }
}
