﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.ToolDevelopmentKit.Logs
{
    using System;
    using System.Reflection;

    /// <summary>
    /// 例外によるログ出力位置です。
    /// </summary>
    public class ExceptionLogLocation : LogLocationTemplate<Exception>, IExceptionLogLocation
    {
        //-----------------------------------------------------------------
        // オブジェクトの生成
        //-----------------------------------------------------------------

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="location">ログ出力位置出力する例外オブジェクトです。</param>
        public ExceptionLogLocation(Exception location)
            : base(location)
        {
        }

        //-----------------------------------------------------------------
        // 文字列化
        //-----------------------------------------------------------------

        /// <summary>
        /// 現在のオブジェクトを表す文字列を返します。
        /// </summary>
        /// <returns>現在のオブジェクトを表す文字列です。</returns>
        public override string ToString()
        {
            MethodBase method = this.Location.TargetSite;
            return string.Format("{0}.{1}()", method.DeclaringType.Name, method.Name);
        }
    }
}
