﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.ToolDevelopmentKit.Logs
{
    using System;

    /// <summary>
    /// 何もしないログ入力です。
    /// </summary>
    public sealed class NullLogInput : LogInput
    {
        //-----------------------------------------------------------------
        // メッセージのみのログを追加
        //-----------------------------------------------------------------

        /// <summary>
        /// ログメッセージを追加します。
        /// </summary>
        /// <param name="message">ログのメッセージです。</param>
        public override void AddMessage(string message)
        {
        }

        /// <summary>
        /// メッセージをフォーマットしてログメッセージを追加します。
        /// </summary>
        /// <param name="message">フォーマットするログのメッセージです。</param>
        /// <param name="args">フォーマット引数です。</param>
        public override void FormatMessage(string message, params object[] args)
        {
        }

        //-----------------------------------------------------------------
        // 文字列によりロケーション指定したログを追加
        //-----------------------------------------------------------------

        /// <summary>
        /// ログを追加します。
        /// </summary>
        /// <param name="location">ログの出力位置です。</param>
        /// <param name="message">ログのメッセージです。</param>
        public override void Add(string location, string message)
        {
        }

        /// <summary>
        /// メッセージをフォーマットしてログを追加します。
        /// </summary>
        /// <param name="location">ログの出力位置です。</param>
        /// <param name="message">フォーマットするログのメッセージです。</param>
        /// <param name="args">フォーマット引数です。</param>
        public override void Format(string location, string message, params object[] args)
        {
        }

        //-----------------------------------------------------------------
        // 例外により出力位置を指定したログを追加
        //-----------------------------------------------------------------

        /// <summary>
        /// ログを追加します。
        /// </summary>
        /// <param name="exception">追加する例外です。</param>
        public override void Add(Exception exception)
        {
        }

        /// <summary>
        /// ログを追加します。
        /// </summary>
        /// <param name="location">ログの出力位置です。</param>
        /// <param name="message">ログのメッセージです。</param>
        public override void Add(Exception location, string message)
        {
        }

        /// <summary>
        /// メッセージをフォーマットしてログを追加します。
        /// </summary>
        /// <param name="location">ログの出力位置です。</param>
        /// <param name="message">フォーマットするログのメッセージです。</param>
        /// <param name="args">フォーマット引数です。</param>
        public override void Format(Exception location, string message, params object[] args)
        {
        }
    }
}
