﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.ToolDevelopmentKit.Conversion
{
    using System;

    /// <summary>
    /// 上書きコピー処理をコンバータに指定するアトリビュートです。
    /// <remarks>
    /// Setterを利用出来ないプロパティで利用します。
    /// プロパティインスタンスのメソッド呼び出しを行いますので、
    /// モデルクラス側はもちろん、シリアライズ用クラスでもコンバート前に
    /// プロパティメンバのインスタンスを生成されている必要があります。
    /// </remarks>
    /// </summary>
    public class OverwriteAttribute : Attribute
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="kind">動作の種類です。</param>
        public OverwriteAttribute(KindType kind)
        {
            this.Kind = kind;
        }

        /// <summary>
        /// 動作の種類です。
        /// </summary>
        public enum KindType
        {
            /// <summary>
            /// 処理しません。
            /// </summary>
            None,

            /// <summary>
            /// リストのセット
            /// </summary>
            ListSet,

            /// <summary>
            /// リストの追加
            /// </summary>
            ListAppend,

            /// <summary>
            /// AddRangeを使わないリストのセット
            /// </summary>
            ListSetOneByOne,

            /// <summary>
            /// ISettableを持つクラスへの設定。
            /// <remarks>
            /// セッターを持たないプロパティなどに利用します。
            /// (ISettableを持たない)プリミティブ型プロパティでは実行時に型を調査し無視します。
            /// したがって、プリミティブ型と非プリミティブ型を多態的に扱うプロパティでも
            /// 指定が可能です。
            /// </remarks>
            /// </summary>
            Set,
        }

        /// <summary>
        /// 動作の種類です。
        /// </summary>
        public KindType Kind { get; set; }
    }
}
