﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.ToolDevelopmentKit.ComponentModel
{
    using System;

    /// <summary>
    /// 破棄されるタイミングで Action を実行するオブジェクトです。
    /// </summary>
    public class DisposeActionObject : IDisposable
    {
        private readonly Action<DisposeActionObject> disposedAction;
        private bool isDisposed = false;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="disposedAction">
        /// 破棄のタイミングで実行するメソッドを指定します。
        /// </param>
        public DisposeActionObject(Action<DisposeActionObject> disposedAction)
        {
            Ensure.Argument.NotNull(disposedAction);
            this.disposedAction = disposedAction;
        }

        /// <summary>
        /// デストラクタです。
        /// </summary>
        ~DisposeActionObject()
        {
            // ファイナライズ時には、Dispose() がコールされているべきです。
            Assertion.Argument.True(this.isDisposed);
        }

        /// <summary>
        /// オブジェクトを破棄します。
        /// </summary>
        void IDisposable.Dispose()
        {
            this.Dispose();
        }

        /// <summary>
        /// オブジェクトを破棄します。
        /// </summary>
        private void Dispose()
        {
            if (this.isDisposed)
            {
                return;
            }

            this.isDisposed = true;

            if (this.disposedAction != null)
            {
                this.disposedAction(this);
            }
        }
    }
}
