﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.ToolDevelopmentKit.Collections
{
    using System.Collections.Generic;

    /// <summary>
    /// null を許容せず、コレクション変更通知をサポートするインスタンスリストです。
    /// </summary>
    /// <typeparam name="TItem">アイテムの型を指定します。</typeparam>
    public class ObservableInstanceList<TItem> : ObservableList<TItem>
    {
        /// <summary>
        /// デフォルトコンストラクタです。
        /// </summary>
        public ObservableInstanceList()
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="source">コピー元の列挙子です。</param>
        public ObservableInstanceList(IEnumerable<TItem> source)
        {
            this.AddRange(source);
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// コレクション内の指定したインデックスの位置にアイテムを挿入します。
        /// </summary>
        /// <param name="index">アイテムの挿入先インデックスを指定します。</param>
        /// <param name="item">新しいアイテムを指定します。</param>
        protected override void InsertItem(int index, TItem item)
        {
            Ensure.Argument.NotNull(item);
            base.InsertItem(index, item);
        }

        /// <summary>
        /// 指定したインデックス位置にあるアイテムを置き換えます。
        /// </summary>
        /// <param name="index">置き換えるアイテムのインデックスを指定します。</param>
        /// <param name="item">新しいアイテムを指定します。</param>
        protected override void SetItem(int index, TItem item)
        {
            Ensure.Argument.NotNull(item);
            base.SetItem(index, item);
        }
    }
}
