﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Drawing;
using System.Runtime.InteropServices;

namespace NWCore.Win32
{
    //---------------------------------------------------------------------
    // WinDef.h
    //---------------------------------------------------------------------

    /// <summary>
    /// Data structure
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct COPYDATASTRUCT
    {
        /// <summary>
        /// Pointer to the data
        /// </summary>
        public IntPtr dwData;

        /// <summary>
        /// Integer of data (Data Size)
        /// </summary>
        public int cbData;

        /// <summary>
        /// Data
        /// </summary>
        public IntPtr lpData;
    }

    #region RECT
    /// <summary>
    /// RECT 構造体。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct RECT
    {
        /// <summary></summary>
        public int	left;
        /// <summary></summary>
        public int	top;
        /// <summary></summary>
        public int	right;
        /// <summary></summary>
        public int	bottom;

        // typedef struct tagRECT
        // {
        //     LONG    left;
        //     LONG    top;
        //     LONG    right;
        //     LONG    bottom;
        // } RECT, *PRECT, NEAR *NPRECT, FAR *LPRECT;

        /// <summary>
        /// Rectangle型に変換。
        /// </summary>
        public Rectangle ToRectangle() { return new Rectangle(left, top, right - left, bottom - top); }
    }
    #endregion

    #region POINT
    /// <summary>
    /// POINT 構造体。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct POINT
    {
        /// <summary></summary>
        public int	x;
        /// <summary></summary>
        public int	y;

        // typedef struct tagPOINT
        // {
        //     LONG  x;
        //     LONG  y;
        // } POINT, *PPOINT, NEAR *NPPOINT, FAR *LPPOINT;

        /// <summary>
        /// Point型に変換。
        /// </summary>
        public Point ToPoint() { return new Point(x, y); }
    }
    #endregion

    #region SIZE
    /// <summary>
    /// SIZE 構造体。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct SIZE
    {
        /// <summary></summary>
        public int	cx;
        /// <summary></summary>
        public int	cy;

        // typedef struct tagSIZE
        // {
        //     LONG        cx;
        //     LONG        cy;
        // } SIZE, *PSIZE, *LPSIZE;

        /// <summary>
        /// Size型に変換。
        /// </summary>
        public Size ToSize() { return new Size(cx, cy); }
    }
    #endregion

    //---------------------------------------------------------------------
    // Winbase.h
    //---------------------------------------------------------------------
    #region MEMORYSTATUSEX
    /// <summary>
    /// MEMORYSTATUSEX 構造体。
    /// </summary>
    [StructLayout( LayoutKind.Sequential )]
    public struct MEMORYSTATUSEX
    {
        /// <summary>Size of the structure in bytes.</summary>
        public uint dwLength;
        /// <summary>Approximate percentage of physical memory that is in use.</summary>
        public uint dwMemoryLoad;
        /// <summary>The amount of actual physical memory, in bytes.</summary>
        public ulong ullTotalPhys;
        /// <summary>The amount of physical memory currently available, in bytes.</summary>
        public ulong ullAvailPhys;
        /// <summary>
        /// The current committed memory limit for the system or the current process, in bytes.
        /// </summary>
        public ulong ullTotalPageFile;
        /// <summary>
        /// The maximum amount of memory the current process can commit, in bytes.
        /// </summary>
        public ulong ullAvailPageFile;
        /// <summary>
        /// The size of the user-mode portion of the virtual address space of the calling process,
        /// in bytes.
        /// </summary>
        public ulong ullTotalVirtual;
        /// <summary>
        /// The amount of unreserved and uncommitted memory currently in the user-mode portion of
        /// the virtual address space of the calling process, in bytes.
        /// </summary>
        public ulong ullAvailVirtual;
        /// <summary>Reserved. This value is always 0.</summary>
        public ulong ullAvailExtendedVirtual;

        /// <summary>
        /// Initialize the structure.
        /// </summary>
        public void Init()
        {
            this.dwLength         = (uint)Marshal.SizeOf( typeof(MEMORYSTATUSEX) );
            this.dwMemoryLoad     = 0;
            this.ullTotalPhys     = 0;
            this.ullAvailPhys     = 0;
            this.ullTotalPageFile = 0;
            this.ullAvailPageFile = 0;
            this.ullTotalVirtual  = 0;
            this.ullAvailVirtual  = 0;

            this.ullAvailExtendedVirtual = 0;
        }
    }
    #endregion

    //---------------------------------------------------------------------
    // WinUser.h
    //---------------------------------------------------------------------
    #region WINDOWPLACEMENT
    /// <summary>
    /// WINDOWPLACEMENT 構造体。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct WINDOWPLACEMENT
    {
        /// <summary></summary>
        public int		length;
        /// <summary></summary>
        public int		flags;
        /// <summary></summary>
        public int		showCmd;
        /// <summary></summary>
        public POINT	ptMinPosition;
        /// <summary></summary>
        public POINT	ptMaxPosition;
        /// <summary></summary>
        public RECT		rcNormalPosition;

        // typedef struct tagWINDOWPLACEMENT {
        //     UINT  length;
        //     UINT  flags;
        //     UINT  showCmd;
        //     POINT ptMinPosition;
        //     POINT ptMaxPosition;
        //     RECT  rcNormalPosition;
        // #ifdef _MAC
        //     RECT  rcDevice;
        // #endif
        // } WINDOWPLACEMENT;
        // typedef WINDOWPLACEMENT *PWINDOWPLACEMENT, *LPWINDOWPLACEMENT;
    }
    #endregion

    #region PAINTSTRUCT
    /// <summary>
    /// PAINTSTRUCT 構造体。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct PAINTSTRUCT
    {
        /// <summary></summary>
        public IntPtr	hdc;
        /// <summary></summary>
        public bool		fErase;
        /// <summary></summary>
        public RECT		rcPaint;
        /// <summary></summary>
        bool			fRestore;
        /// <summary></summary>
        bool			fIncUpdate;
        /// <summary></summary>
        int				reserved0;
        /// <summary></summary>
        int				reserved1;
        /// <summary></summary>
        int				reserved2;
        /// <summary></summary>
        int				reserved3;
        /// <summary></summary>
        int				reserved4;
        /// <summary></summary>
        int				reserved5;
        /// <summary></summary>
        int				reserved6;
        /// <summary></summary>
        int				reserved7;

        // typedef struct tagPAINTSTRUCT {
        //     HDC         hdc;
        //     BOOL        fErase;
        //     RECT        rcPaint;
        //     BOOL        fRestore;
        //     BOOL        fIncUpdate;
        //     BYTE        rgbReserved[32];
        // } PAINTSTRUCT, *PPAINTSTRUCT, *NPPAINTSTRUCT, *LPPAINTSTRUCT;
    }
    #endregion

    #region DRAWITEMSTRUCT
    /// <summary>
    /// DRAWITEMSTRUCT 構造体。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct DRAWITEMSTRUCT
    {
        /// <summary></summary>
        public int		CtlType;
        /// <summary></summary>
        public int		CtlID;
        /// <summary></summary>
        public int		itemID;
        /// <summary></summary>
        public int		itemAction;
        /// <summary></summary>
        public int		itemState;
        /// <summary></summary>
        public IntPtr	hwndItem;
        /// <summary></summary>
        public IntPtr	hDC;
        /// <summary></summary>
        public RECT		rcItem;
        /// <summary></summary>
        public IntPtr	itemData;

        // typedef struct tagDRAWITEMSTRUCT {
        //     UINT        CtlType;
        //     UINT        CtlID;
        //     UINT        itemID;
        //     UINT        itemAction;
        //     UINT        itemState;
        //     HWND        hwndItem;
        //     HDC         hDC;
        //     RECT        rcItem;
        //     ULONG_PTR   itemData;
        // } DRAWITEMSTRUCT, NEAR *PDRAWITEMSTRUCT, FAR *LPDRAWITEMSTRUCT;
    }
    #endregion

    #region NMHDR
    /// <summary>
    /// NMHDR 構造体。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct NMHDR
    {
        /// <summary></summary>
        public IntPtr	hwndFrom;
        /// <summary></summary>
        public int		idFrom;
        /// <summary></summary>
        public int		code;         // NM_ code

        // typedef struct tagNMHDR
        // {
        //     HWND      hwndFrom;
        //     UINT_PTR  idFrom;
        //     UINT      code;
        // } NMHDR;
    }
    #endregion

    //---------------------------------------------------------------------
    // CommCtrl.h
    //---------------------------------------------------------------------
    #region NMCUSTOMDRAW
    /// <summary>
    /// NMCUSTOMDRAW 構造体。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct NMCUSTOMDRAW
    {
        /// <summary></summary>
        public NMHDR	hdr;
        /// <summary></summary>
        public int		dwDrawStage;
        /// <summary></summary>
        public IntPtr	hdc;
        /// <summary></summary>
        public RECT		rc;
        /// <summary></summary>
        public int		dwItemSpec;  // this is control specific, but it's how to specify an item.  valid only with CDDS_ITEM bit set
        /// <summary></summary>
        public int		uItemState;
        /// <summary></summary>
        public IntPtr	lItemlParam;

        // typedef struct tagNMCUSTOMDRAWINFO
        // {
        //     NMHDR hdr;
        //     DWORD dwDrawStage;
        //     HDC hdc;
        //     RECT rc;
        //     DWORD_PTR dwItemSpec;
        //     UINT  uItemState;
        //     LPARAM lItemlParam;
        // } NMCUSTOMDRAW, *LPNMCUSTOMDRAW;
    }
    #endregion

    #region NMLVCUSTOMDRAW
    /// <summary>
    /// NMLVCUSTOMDRAW 構造体。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct NMLVCUSTOMDRAW
    {
        /// <summary></summary>
        public NMCUSTOMDRAW	nmcd;
        /// <summary></summary>
        public uint			clrText;
        /// <summary></summary>
        public uint			clrTextBk;
        /// <summary></summary>
        public int			iSubItem;

        // typedef struct tagNMLVCUSTOMDRAW
        // {
        //     NMCUSTOMDRAW nmcd;
        //     COLORREF clrText;
        //     COLORREF clrTextBk;
        // #if (_WIN32_IE >= 0x0400)
        //     int iSubItem;
        // #endif
        // #if (_WIN32_WINNT >= 0x501)
        //     DWORD dwItemType;
        //
        //     // Item custom draw
        //     COLORREF clrFace;
        //     int iIconEffect;
        //     int iIconPhase;
        //     int iPartId;
        //     int iStateId;
        //
        //     // Group Custom Draw
        //     RECT rcText;
        //     UINT uAlign;      // Alignment. Use LVGA_HEADER_CENTER, LVGA_HEADER_RIGHT, LVGA_HEADER_LEFT
        // #endif
        // } NMLVCUSTOMDRAW, *LPNMLVCUSTOMDRAW;
    }
    #endregion

    #region NMHEADER
    /// <summary>
    /// NMHEADER 構造体。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct NMHEADER
    {
        /// <summary></summary>
        public NMHDR	hdr;
        /// <summary></summary>
        public int		iItem;
        /// <summary></summary>
        public int		iButton;
        /// <summary></summary>
        public IntPtr	pitem;

        // typedef struct tagNMHEADERW
        // {
        //     NMHDR   hdr;
        //     int     iItem;
        //     int     iButton;
        //     HDITEMW *pitem;
        // } NMHEADERW, *LPNMHEADERW;
    }
    #endregion

    #region HDITEM
    /// <summary>
    /// HDITEM 構造体。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct HDITEM
    {
        /// <summary></summary>
        public int		mask;
        /// <summary></summary>
        public int		cxy;
        /// <summary></summary>
        public string	pszText;	// TODO: IntPtr の方がよいか？
        /// <summary></summary>
        public IntPtr	hbm;
        /// <summary></summary>
        public int		cchTextMax;
        /// <summary></summary>
        public int		fmt;
        /// <summary></summary>
        public IntPtr	lParam;
        /// <summary></summary>
        public int		iImage;
        /// <summary></summary>
        public int		iOrder;
        /// <summary></summary>
        public int		type;
        /// <summary></summary>
        public IntPtr	pvFilter;

        // typedef struct _HD_ITEMW
        // {
        //     UINT    mask;
        //     int     cxy;
        //     LPWSTR   pszText;
        //     HBITMAP hbm;
        //     int     cchTextMax;
        //     int     fmt;
        //     LPARAM  lParam;
        // #if (_WIN32_IE >= 0x0300)
        //     int     iImage;        // index of bitmap in ImageList
        //     int     iOrder;
        // #endif
        // #if (_WIN32_IE >= 0x0500)
        //     UINT    type;           // [in] filter type (defined what pvFilter is a pointer to)
        //     void *  pvFilter;       // [in] fillter data see above
        // #endif
        // } HDITEMW, *LPHDITEMW;
    }
    #endregion

    #region TVHITTESTINFO
    /// <summary>
    /// TVHITTESTINFO 構造体。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct TVHITTESTINFO
    {
        /// <summary></summary>
        public POINT	pt;
        /// <summary></summary>
        public uint		flags;
        /// <summary></summary>
        public IntPtr	hItem;

        // typedef struct tagTVHITTESTINFO {
        //     POINT       pt;
        //     UINT        flags;
        //     HTREEITEM   hItem;
        // } TVHITTESTINFO, *LPTVHITTESTINFO;
    }
    #endregion

    //---------------------------------------------------------------------
    // ShellAPI.h
    //---------------------------------------------------------------------
    #region SHFILEINFO
    /// <summary>
    /// SHFILEINFO 構造体。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct SHFILEINFO
    {
        /// <summary></summary>
        public IntPtr	hIcon;
        /// <summary></summary>
        public int		iIcon;
        /// <summary></summary>
        public int		dwAttributes;
        /// <summary></summary>
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst=Constants.MAX_PATH)]
        public string	szDisplayName;
        /// <summary></summary>
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst=80)]
        public string	szTypeName;

        //typedef struct _SHFILEINFOA
        //{
        //        HICON       hIcon;                      // out: icon
        //        int         iIcon;                      // out: icon index
        //        DWORD       dwAttributes;               // out: SFGAO_ flags
        //        CHAR        szDisplayName[MAX_PATH];    // out: display name (or path)
        //        CHAR        szTypeName[80];             // out: type name
        //} SHFILEINFOA;
        //typedef struct _SHFILEINFOW
        //{
        //        HICON       hIcon;                      // out: icon
        //        int         iIcon;                      // out: icon index
        //        DWORD       dwAttributes;               // out: SFGAO_ flags
        //        WCHAR       szDisplayName[MAX_PATH];    // out: display name (or path)
        //        WCHAR       szTypeName[80];             // out: type name
        //} SHFILEINFOW;
    }
    #endregion
}
