﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using NWCore.Protocols;

namespace NWCore.Viewer
{
    /// <summary>
    /// Interface for message processors.
    /// </summary>
    public interface IMessageProcessor
    {
        /// <summary>
        /// Dispatch received packet to the registered listeners.
        /// </summary>
        /// <param name="header">Packet header</param>
        /// <param name="packet">Packet</param>
        /// <param name="extraPacketData">Extra packet data</param>
        void ProcessMessage(Header header, Protocol4FReader reader);


        /// <summary>
        /// Check if should filter the message.
        /// </summary>
        /// <param name="msgType">The type of the message.</param>
        /// <returns>True to keep the message, false discard it.</returns>
        bool FilterMessage(MessageType msgType);
    }
}
