﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Xml.Serialization;
using NintendoWare.ToolDevelopmentKit;
using NintendoWare.ToolDevelopmentKit.Conversion;
using NintendoWare.ToolDevelopmentKit.Xml;
using NWCore.DataModel.Major_0.Minor_0.Build_0.Revision_0;

namespace NWCore.Serializer.Major_0.Minor_0.Build_0.Revision_0
{
    /// <summary>
    /// 全エミッタ共通データのシリアライズ用クラスです
    /// </summary>
    [XmlRoot("root")]
    public class EnvConfigDataXml
    {
        #region Classes

        /// <summary>
        /// エミッタ用コンフィグ設定用
        /// </summary>
        [XmlType("EmitterSetData")]
        public class EmitterSetConfigXml
        {
            /// <summary>
            /// コンストラクタ
            /// </summary>
            public EmitterSetConfigXml()
            {
                this.GameConfigData = new GameConfigData();
                this.EmitterGameDatas = new List<EmitterGameData>();
            }

            /// <summary>
            /// エミッタセットのファイルパス
            /// </summary>
            [XmlAttribute]
            public string Path { get; set; }

            /// <summary>
            /// ゲーム設定
            /// </summary>
            public GameConfigData GameConfigData { get; set; }

            /// <summary>
            /// エミッタ単位の設定
            /// </summary>
            public List<EmitterGameData> EmitterGameDatas { get; set; }
        }

        #endregion

        #region Construtors

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public EnvConfigDataXml()
        {
            this.ConfigData = new EnvConfigData();
            this.EmitterSetList = new List<EmitterSetConfigXml>();
        }

        #endregion

        #region Properties

        /// <summary>
        /// コンフィグ設定データ
        /// </summary>
        public EnvConfigData ConfigData
        {
            get;
            set;
        }

        /// <summary>
        /// 保持しているパーティクルドキュメントのリスト
        /// </summary>
        [XmlArrayItem("EmitterSet")]
        public List<EmitterSetConfigXml> EmitterSetList
        {
            get;
            set;
        }

        #endregion

    }
}
