﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.IO;
using System.Xml.Serialization;
using NintendoWare.ToolDevelopmentKit;
using NintendoWare.ToolDevelopmentKit.Xml;

namespace NWCore.Serializer
{
    /// <summary>
    /// シリアライズ用のベースクラス
    /// </summary>
    public static class UtilityXml
    {
        /// <summary>
        /// -> ToVector4Xml
        /// </summary>
        public static Vector4Xml ToVector4Xml( Vector4 vec )
        {
            Vector4Xml vecXml = new Vector4Xml();

            vecXml.X = vec.X;
            vecXml.Y = vec.Y;
            vecXml.Z = vec.Z;
            vecXml.W = vec.W;

            return vecXml;
        }

        /// <summary>
        /// -> ToVector3
        /// </summary>
        public static Vector4 ToVector4( Vector4Xml vecXml )
        {
            return new Vector4( vecXml.X, vecXml.Y, vecXml.Z, vecXml.W );
        }

        /// <summary>
        /// -> ToVector3Xml
        /// </summary>
        public static Vector3Xml ToVector3Xml(Vector3 vec)
        {
            return new Vector3Xml(vec.X, vec.Y, vec.Z);
        }

        /// <summary>
        /// -> ToVector3
        /// </summary>
        public static Vector3 ToVector3(Vector3Xml vecXml)
        {
            return new Vector3(vecXml.X, vecXml.Y, vecXml.Z);
        }

        /// <summary>
        /// -> ToVector2Xml
        /// </summary>
        public static Vector2Xml ToVector2Xml(Vector2 vec)
        {
            var vec2Xml = new Vector2Xml();
            vec2Xml.X = vec.X;
            vec2Xml.Y = vec.Y;
            return vec2Xml;
        }

        /// <summary>
        /// -> ToVector2
        /// </summary>
        public static Vector2 ToVector2(Vector2Xml vecXml)
        {
            return new Vector2(vecXml.X, vecXml.Y);
        }

        /// <summary>
        /// -> ToRgbaColorXml
        /// </summary>
        public static RgbaColorXml ToRgbaColorXml(RgbaColor rgba)
        {
            var rgbaXml = new RgbaColorXml();
            rgbaXml.R = rgba.R;
            rgbaXml.G = rgba.G;
            rgbaXml.B = rgba.B;
            rgbaXml.A = rgba.A;
            return rgbaXml;
        }

        /// <summary>
        /// -> ToRgbaColor
        /// </summary>
        public static RgbaColor ToRgbaColor(RgbaColorXml rgbaXml)
        {
            return new RgbaColor(rgbaXml.R, rgbaXml.G, rgbaXml.B, rgbaXml.A);
        }
    }
}
