﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Text.RegularExpressions;

namespace EffectMaker.Foundation.Utility
{
    /// <summary>
    /// Utility for regular expression operations.
    /// </summary>
    public static class RegexUtility
    {
        /// <summary>
        /// Match tokens in the given regular expression string.
        /// </summary>
        /// <param name="expression">The regular expression string.</param>
        /// <param name="str">The string to perform string extraction.</param>
        /// <returns>The matched string tokens.</returns>
        public static string[] ExtractStrings(string expression, string str)
        {
            var regex = new Regex(expression);

            MatchCollection matches = regex.Matches(str);

            string[] matchedTokens = new string[matches.Count];
            for (int i = 0; i < matches.Count; ++i)
            {
                Match match = matches[i];
                if (match.Success == true && match.Groups.Count >= 2)
                {
                    matchedTokens[i] = match.Groups[1].Value;
                }
                else
                {
                    matchedTokens[i] = null;
                }
            }

            return matchedTokens;
        }
    }
}
