﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;

namespace EffectMaker.Foundation.Serialization
{
    /// <summary>
    /// Event argument class for requesting extra types for deserialization.
    /// </summary>
    public class RequestExtraTypesEventArgs : EventArgs
    {
        /// <summary>The list of extra types.</summary>
        private List<Type> extraTypeList = new List<Type>();

        /// <summary>
        /// Constructor.
        /// </summary>
        public RequestExtraTypesEventArgs() :
            base()
        {
        }

        /// <summary>
        /// Get the extra types.
        /// </summary>
        public Type[] ExtraTypes
        {
            get
            {
                return this.extraTypeList.ToArray();
            }
        }

        /// <summary>
        /// Add extra types.
        /// </summary>
        /// <param name="extraTypes">The extra types to add.</param>
        public void AddExtraTypes(IEnumerable<Type> extraTypes)
        {
            this.extraTypeList.AddRange(extraTypes);
        }
    }
}
