﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Collections.Generic;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// ビューアノード/カメラタブ/ビューグループデータです。
    /// </summary>
    [Serializable]
    public class ViewerCameraViewData : DataModelBase
    {
        /// <summary>
        /// カメラの位置です.
        /// </summary>
        private Vector3f cameraPosition = null;

        /// <summary>
        /// カメラの注視点です.
        /// </summary>
        private Vector3f cameraTarget = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ViewerCameraViewData() :
            base()
        {
            this.CameraPosition = new Vector3f(80.0f, 40.0f, 80.0f);
            this.CameraTarget = new Vector3f(0.0f, 0.0f, 0.0f);
            this.CameraRotation = 0.0f;
        }

        /// <summary>
        /// カメラの位置です.
        /// </summary>
        [DataModelPropertyGuid("d99caf98-542c-4c29-bcaa-8dd1bfa8f3e4")]
        public Vector3f CameraPosition
        {
            get { return this.GetObjectFromField(ref this.cameraPosition, false); }
            set { this.SetISettableToField(ref this.cameraPosition, value); }
        }

        /// <summary>
        /// カメラの注視点です.
        /// </summary>
        [DataModelPropertyGuid("401ba1cd-39c5-416d-ae1f-dad5fdb677b6")]
        public Vector3f CameraTarget
        {
            get { return this.GetObjectFromField(ref this.cameraTarget, false); }
            set { this.SetISettableToField(ref this.cameraTarget, value); }
        }

        /// <summary>
        /// カメラの回転角(ツイスト角)です.
        /// </summary>
        [DataModelPropertyGuid("e1a705a0-5928-454b-ac9d-ae5a49109a3f")]
        public float CameraRotation { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as ViewerCameraViewData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.CameraPosition = srcDataModel.CameraPosition;
            this.CameraTarget = srcDataModel.CameraTarget;
            this.CameraRotation = srcDataModel.CameraRotation;

            return true;
        }
    }
}
