﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// ビューアノード/カメラタブです。
    /// </summary>
    [Serializable]
    public class ViewerCameraData : DataModelBase
    {
        /// <summary>
        /// ビューグループです。
        /// </summary>
        private ViewerCameraViewData viewData = null;

        /// <summary>
        /// 射影グループです。
        /// </summary>
        private ViewerProjectionData projectionData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ViewerCameraData() :
            base()
        {
        }

        /// <summary>
        /// ビューグループです。
        /// </summary>
        [DataModelPropertyGuid("28447927-82d5-411c-9d9d-c2d4d31d1262")]
        public ViewerCameraViewData ViewData
        {
            get { return this.GetDataModelFromField(ref this.viewData, false); }
            set { this.SetDataModelToField(ref this.viewData, value); }
        }

        /// <summary>
        /// 射影グループです。
        /// </summary>
        [DataModelPropertyGuid("de8e833f-ee6b-47dc-a9fd-000eaa3a0afb")]
        public ViewerProjectionData ProjectionData
        {
            get { return this.GetDataModelFromField(ref this.projectionData, false); }
            set { this.SetDataModelToField(ref this.projectionData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as ViewerCameraData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ViewData = srcDataModel.ViewData;
            this.ProjectionData = srcDataModel.ProjectionData;

            return true;
        }
    }
}
