﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// ビューアノード/背景画像タブ/背景画像グループです。
    /// </summary>
    [Serializable]
    public class ViewerBackgroundImageData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ViewerBackgroundImageData() :
            base()
        {
            this.ImageFilePath = string.Empty;
        }

        /// <summary>
        /// ファイルパスです。
        /// </summary>
        [DataModelPropertyGuid("a39794d3-ce12-4837-b34c-e85e4aea3d83")]
        public string ImageFilePath { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as ViewerBackgroundImageData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ImageFilePath = srcDataModel.ImageFilePath;

            return true;
        }
    }
}
