﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using ComboBoxItemType = System.Collections.Generic.KeyValuePair<string, object>;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Collections.Generic;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// 連結式ストライプ
    /// </summary>
    [Serializable]
    public class StripeSuperUserData : UserDataBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public StripeSuperUserData() :
            base()
        {
            this.StripeType = 0;
            this.FollowEmitter = false;
            this.Option = 0;
            this.TexCoordType = 0;
            this.NumDivisions = 0;
            this.ConnectionType = 0;
            this.StartSliceAlpha = 1.0f;
            this.EndSliceAlpha = 1.0f;
            this.HistInterpolation = 1.0f;
            this.DirInterpolation = 1.0f;
        }

        /// <summary>
        /// 計算方式
        /// </summary>
        [DataModelPropertyGuid("5c3c335a-797f-4ea3-aeb6-b70fb839bb6d")]
        public int StripeType { get; set; }

        /// <summary>
        /// エミッタに完全追従
        /// </summary>
        [DataModelPropertyGuid("6f47ff97-44f5-4863-81be-bae03e6e1675")]
        public bool FollowEmitter { get; set; }

        /// <summary>
        /// オプション
        /// </summary>
        [DataModelPropertyGuid("889c48b3-4646-4087-99c4-e462cb732440")]
        public int Option { get; set; }

        /// <summary>
        /// テクスチャリング
        /// </summary>
        [DataModelPropertyGuid("0b2ef3e3-3ce1-4655-b01a-25cdb8ba2147")]
        public int TexCoordType { get; set; }

        /// <summary>
        /// 分割数
        /// </summary>
        [DataModelPropertyGuid("a57ca93f-837f-4c03-ab20-716adc454abe")]
        public int NumDivisions { get; set; }

        /// <summary>
        /// 接続タイプ
        /// </summary>
        [DataModelPropertyGuid("26429a1c-dc0b-4c92-87fb-91e4f6b56dcd")]
        public int ConnectionType { get; set; }

        /// <summary>
        /// 先端α
        /// </summary>
        [DataModelPropertyGuid("85c39097-58c3-43fc-bbbe-b8caa4baf23c")]
        public float StartSliceAlpha { get; set; }

        /// <summary>
        /// 末端α
        /// </summary>
        [DataModelPropertyGuid("d3e35980-1970-4861-91fc-29ec9f3990f6")]
        public float EndSliceAlpha { get; set; }

        /// <summary>
        /// 履歴補間パラメータ
        /// </summary>
        [DataModelPropertyGuid("13dadd5d-f566-487d-ae09-d629394e334e")]
        public float HistInterpolation { get; set; }

        /// <summary>
        /// 方向補間率
        /// </summary>
        [DataModelPropertyGuid("ad84425c-c022-42f5-99e7-f042ee69d0f9")]
        public float DirInterpolation { get; set; }

        /// <summary>
        /// ストライプタイプ.
        ///
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("0665e12f-f909-4a41-a1c6-d3c712b577ae")]
        public IEnumerable<ComboBoxItemType> StripeTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType("ビルボードストライプ", 0),
                    new ComboBoxItemType("エミッタ行列ストライプ", 1),
                    new ComboBoxItemType("エミッタの上下に伸ばす", 2),
                };
            }
        }

        /// <summary>
        /// オプションタイプ.
        ///
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("a0333b7f-b335-4a09-ad4b-08b7864d2e99")]
        public IEnumerable<ComboBoxItemType> OptionTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType("通常", 0),
                    new ComboBoxItemType("クロス", 1),
                };
            }
        }

        /// <summary>
        /// テクスチャ座標タイプ.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("e6f7b82c-67f8-4961-89be-ae79e4117e6d")]
        public IEnumerable<ComboBoxItemType> TexCoordTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType("全て貼る", 0),
                    new ComboBoxItemType("描画範囲に合わせて貼る", 1),
                };
            }
        }

        /// <summary>
        /// 接続タイプ.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("75da6541-ec96-47fd-8627-007aec5c4804")]
        public IEnumerable<ComboBoxItemType> ConnectionTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType("通常", 0),
                    new ComboBoxItemType("先端に繋ぐ", 1),
                    new ComboBoxItemType("エミッタに繋ぐ", 2),
                };
            }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as StripeSuperUserData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.StripeType = srcDataModel.StripeType;
            this.FollowEmitter = srcDataModel.FollowEmitter;
            this.Option = srcDataModel.Option;
            this.TexCoordType = srcDataModel.TexCoordType;
            this.NumDivisions = srcDataModel.NumDivisions;
            this.ConnectionType = srcDataModel.ConnectionType;
            this.StartSliceAlpha = srcDataModel.StartSliceAlpha;
            this.EndSliceAlpha = srcDataModel.EndSliceAlpha;
            this.HistInterpolation = srcDataModel.HistInterpolation;
            this.DirInterpolation = srcDataModel.DirInterpolation;

            return true;
        }
    }
}
