﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// Class for custom shader tag data.
    /// </summary>
    [Serializable]
    public class CustomShaderData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public CustomShaderData() :
            base()
        {
            this.CustomShaderSetting = 0;
        }

        /// <summary>
        /// カスタムシェーダセッティングです.
        /// </summary>
        [DataModelPropertyGuid("90d0c666-7d79-429e-95ec-3e8fb499b4f1")]
        public int CustomShaderSetting { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CustomShaderData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.CustomShaderSetting = srcDataModel.CustomShaderSetting;

            return true;
        }
    }
}
