﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// Class for a sample data model.
    /// </summary>
    [Serializable]
    public class SampleDataModel : DataModelBase
    {
        /// <summary>
        /// Default constructor.
        /// </summary>
        public SampleDataModel()
        {
            this.Name     = string.Empty;
            this.Birthday = DateTime.MinValue;
            this.Height   = 0.0f;
            this.Weight   = 0.0f;
        }

        /// <summary>
        /// Get or set the name of the employee.
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// Get or set the birthday of the employee.
        /// </summary>
        public DateTime Birthday { get; set; }

        /// <summary>
        /// Get or set the height of the employee.
        /// </summary>
        public float Height { get; set; }

        /// <summary>
        /// Get or set the weight of the employee.
        /// </summary>
        public float Weight { get; set; }

        /// <summary>
        /// Set data from the source data model.
        /// </summary>
        /// <param name="src">The source data model.</param>
        /// <returns>True on success.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as SampleDataModel;
            if (srcDataModel == null)
            {
                return false;
            }

            this.Name     = srcDataModel.Name;
            this.Birthday = srcDataModel.Birthday;
            this.Height   = srcDataModel.Height;
            this.Weight   = srcDataModel.Weight;

            return true;
        }
    }
}
