﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Reflection;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// パーティクルスケールタブデータです。
    /// </summary>
    [Serializable]
    public class PreviewParticleScaleData : DataModelBase
    {
        /// <summary>
        /// パーティクルの大きさ
        /// </summary>
        private Vector2f particleScale = null;

        /// <summary>
        /// 放出時のみ作用するパーティクルの大きさ
        /// </summary>
        private Vector2f emissionParticleScale = null;

        /// <summary>
        /// エミッタ形状スケール
        /// </summary>
        private Vector3f emitterScale = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public PreviewParticleScaleData() :
            base()
        {
            this.ParticleScale = new Vector2f(1.0f, 1.0f);
            this.EmissionParticleScale = new Vector2f(1.0f, 1.0f);
            this.EmitterScale = new Vector3f(1.0f, 1.0f, 1.0f);
        }

        /// <summary>
        /// パーティクルの大きさ
        /// </summary>
        [DataModelPropertyGuid("bf1d9d03-5689-424f-9cfc-393e8cf570a7")]
        public Vector2f ParticleScale
        {
            get { return this.GetObjectFromField(ref this.particleScale, false); }
            set { this.SetISettableToField(ref this.particleScale, value); }
        }

        /// <summary>
        /// 放出時のみ作用するパーティクルの大きさ
        /// </summary>
        [DataModelPropertyGuid("ec0c0e28-2025-49e4-8b98-2bf0153c24eb")]
        public Vector2f EmissionParticleScale
        {
            get { return this.GetObjectFromField(ref this.emissionParticleScale, false); }
            set { this.SetISettableToField(ref this.emissionParticleScale, value); }
        }

        /// <summary>
        /// エミッタ形状スケール
        /// </summary>
        [DataModelPropertyGuid("25514ab4-8ab0-408b-99d4-dd36fcd6a346")]
        public Vector3f EmitterScale
        {
            get { return this.GetObjectFromField(ref this.emitterScale, false); }
            set { this.SetISettableToField(ref this.emitterScale, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as PreviewParticleScaleData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ParticleScale = srcDataModel.ParticleScale;
            this.EmissionParticleScale = srcDataModel.EmissionParticleScale;
            this.EmitterScale = srcDataModel.EmitterScale;

            return true;
        }
    }
}
