﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Collections.Generic;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// モデルノードです。
    /// </summary>
    [Serializable]
    public class ModelData : DataModelBase
    {
        /// <summary>
        /// 基本設定データです。
        /// </summary>
        private ModelBasicSettingData modelBasicSettingData = null;

        /// <summary>
        /// ボーン名です。
        /// </summary>
        private List<string> boneNames = null;

        /// <summary>
        ///
        /// </summary>
        private ModelConstrainData constrain = null;

        /// <summary>
        ///
        /// </summary>
        private ModelAutoMoveData autoMove = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ModelData() :
            base()
        {
            this.Name = string.Empty;
            this.IsRuntime = false;
            this.ModelBinaryId = -1;
        }

        /// <summary>
        /// 基本設定データです。
        /// </summary>
        [DataModelPropertyGuid("0523dc0c-424b-403e-898f-79bf9c3a439b")]
        public ModelBasicSettingData ModelBasicSettingData
        {
            get { return this.GetDataModelFromField(ref this.modelBasicSettingData, false); }
            set { this.SetDataModelToField(ref this.modelBasicSettingData, value); }
        }

        /// <summary>
        /// モデル名です。
        /// </summary>
        [DataModelPropertyGuid("834ed8d5-8992-47c6-a11c-3e09984970f5")]
        public string Name { get; set; }

        /// <summary>
        /// ボーン名です。

        /// </summary>
        [DataModelPropertyGuid("1f7dd097-b96c-4aab-ab62-9033baa75583")]
        public List<string> BoneNames
        {
            get { return this.GetValueListFromField(ref this.boneNames); }
            set { this.SetValueListToField(ref this.boneNames, value); }
        }

        /// <summary>
        /// ランタイムで独立して管理しているモデルのデータモデルかどうかのフラグです.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("19e2f09d-4b25-4fae-a534-d45724af50ca")]
        public bool IsRuntime { get; set; }

        /// <summary>
        /// モデルバイナリのIDです.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("85e10561-e113-43ea-a339-ba52ac46374a")]
        public int ModelBinaryId { get; set; }

        /// <summary>
        ///
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("561a794d-2445-4e3e-b49b-1651d94d25c6")]
        public ModelConstrainData Constrain
        {
            get { return this.GetDataModelFromField(ref this.constrain, false); }
            set { this.SetDataModelToField(ref this.constrain, value); }
        }

        /// <summary>
        ///
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("0a569402-1ba5-4260-878c-1d97e4c33d12")]
        public ModelAutoMoveData AutoMove
        {
            get { return this.GetDataModelFromField(ref this.autoMove, false); }
            set { this.SetDataModelToField(ref this.autoMove, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as ModelData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ModelBasicSettingData = srcDataModel.ModelBasicSettingData;
            this.Name = srcDataModel.Name;
            this.BoneNames = srcDataModel.BoneNames;
            this.IsRuntime = srcDataModel.IsRuntime;
            this.ModelBinaryId = srcDataModel.ModelBinaryId;
            this.Constrain = srcDataModel.Constrain;
            this.AutoMove = srcDataModel.AutoMove;

            return true;
        }
    }
}
