﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// モデルノード/基本設定タブデータです。
    /// </summary>
    [Serializable]
    public class ModelBasicSettingData : DataModelBase
    {
        /// <summary>
        /// モデルノード/基本設定タブ/キャラクタアニメグループデータです。
        /// </summary>
        private ModelBasicAnimationData modelBasicAnimationData = null;

        /// <summary>
        /// モデルノード/基本設定タブ/モデルグループです。
        /// </summary>
        private ModelBasicModelData modelBasicModelData = null;

        /// <summary>
        /// モデルノード/基本設定タブ/再生設定グループデータです。
        /// </summary>
        private ModelBasicPlaybackData modelBasicPlaybackData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ModelBasicSettingData() :
            base()
        {
        }

        /// <summary>
        /// モデルノード/基本設定タブ/キャラクタアニメグループデータです。
        /// </summary>
        [DataModelPropertyGuid("e980cb10-6bb2-4edf-8221-012af46a414f")]
        public ModelBasicAnimationData ModelBasicAnimationData
        {
            get { return this.GetDataModelFromField(ref this.modelBasicAnimationData, false); }
            set { this.SetDataModelToField(ref this.modelBasicAnimationData, value); }
        }

        /// <summary>
        /// モデルノード/基本設定タブ/モデルグループです。
        /// </summary>
        [DataModelPropertyGuid("4a07fe3e-5a76-4669-bf3e-c649a1cac19d")]
        public ModelBasicModelData ModelBasicModelData
        {
            get { return this.GetDataModelFromField(ref this.modelBasicModelData, false); }
            set { this.SetDataModelToField(ref this.modelBasicModelData, value); }
        }

        /// <summary>
        /// モデルノード/基本設定タブ/再生設定グループデータです。
        /// </summary>
        [DataModelPropertyGuid("534bfbf2-68a3-45ad-bd34-1dc2e401514b")]
        public ModelBasicPlaybackData ModelBasicPlaybackData
        {
            get { return this.GetDataModelFromField(ref this.modelBasicPlaybackData, false); }
            set { this.SetDataModelToField(ref this.modelBasicPlaybackData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as ModelBasicSettingData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ModelBasicAnimationData = srcDataModel.ModelBasicAnimationData;
            this.ModelBasicModelData = srcDataModel.ModelBasicModelData;
            this.ModelBasicPlaybackData = srcDataModel.ModelBasicPlaybackData;

            return true;
        }
    }
}
