﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// フィールドノード/スピンタブです。
    /// </summary>
    [Serializable]
    public class SpinData : FieldDataBase
    {
        /// <summary>
        /// スピングループデータです。
        /// </summary>
        private SpinParamData spinParamData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public SpinData() :
            base()
        {
        }

        /// <summary>
        /// スピングループデータです。
        /// </summary>
        [DataModelPropertyGuid("5e8bc7e2-85de-443d-946b-1fd6edaea0d9")]
        public SpinParamData SpinParamData
        {
            get { return this.GetDataModelFromField(ref this.spinParamData, false); }
            set { this.SetDataModelToField(ref this.spinParamData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as SpinData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.SpinParamData = srcDataModel.SpinParamData;

            return true;
        }
    }
}
