﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Linq;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// 位相の統一
    /// </summary>
    [Serializable]
    public class RandomUnifiedPhaseParam : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public RandomUnifiedPhaseParam() :
            base()
        {
            this.EnableUnifiedPhase = false;
            this.Speed = 0.0f;
            this.Distribution = 0.0f;
        }

        /// <summary>
        /// 「位相の統一」のON/OFF
        /// </summary>
        [DataModelPropertyGuid("e131473b-8220-4688-8184-16c55fc3c717")]
        public bool EnableUnifiedPhase { get; set; }

        /// <summary>
        /// 位相の変化速度
        /// </summary>
        [DataModelPropertyGuid("559eba3b-3a0a-42fe-a6fb-4d7b9460f9c0")]
        public float Speed { get; set; }

        /// <summary>
        /// 位相のばらつき
        /// </summary>
        [DataModelPropertyGuid("180151e9-94e3-417d-afa9-c19be155ceae")]
        public float Distribution { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as RandomUnifiedPhaseParam;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EnableUnifiedPhase = srcDataModel.EnableUnifiedPhase;
            this.Speed = srcDataModel.Speed;
            this.Distribution = srcDataModel.Distribution;

            return true;
        }
    }
}
