﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// フィールドノード/ランダムタブ/ランダムグループデータです。
    /// </summary>
    [Serializable]
    public class RandomFe1ParamData : DataModelBase
    {
        /// <summary>
        /// ランダム幅です。
        /// </summary>
        private Vector3f randomRange = null;

        /// <summary>
        /// アニメーションテーブルです。
        /// </summary>
        private AnimationTableData animationTable = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public RandomFe1ParamData() :
            base()
        {
            this.RandomRange = new Vector3f(0.0f, 0.0f, 0.0f);
            this.BlankFrames = 0;
            this.EnableAnimation = 0;
            this.LoopMode = 0;
            this.LoopEnd = 100;
            this.Randomize = 0;
        }

        /// <summary>
        /// ランダム幅です。
        /// </summary>
        [DataModelPropertyGuid("0c491828-90ab-4fb4-95f3-098115d96253")]
        public Vector3f RandomRange
        {
            get { return this.GetObjectFromField(ref this.randomRange, false); }
            set { this.SetISettableToField(ref this.randomRange, value); }
        }

        /// <summary>
        /// ランダム適用間隔(フレーム)です。
        /// </summary>
        [DataModelPropertyGuid("870c4b56-846a-41a8-a3b7-e35336377749")]
        public int BlankFrames { get; set; }

        /// <summary>
        /// アニメーションの有無を表すフラグです。
        /// </summary>
        [DataModelPropertyGuid("59e5d441-d056-482a-9723-1cf6ffa7a59b")]
        public int EnableAnimation { get; set; }

        /// <summary>
        /// アニメーションテーブルです。
        /// </summary>
        [DataModelPropertyGuid("65a0c3cd-6e4d-444f-ac70-3b00a19a3b3b")]
        public AnimationTableData AnimationTable
        {
            get { return this.GetObjectFromField(ref this.animationTable, false); }
            set { this.SetISettableToField(ref this.animationTable, value); }
        }

        /// <summary>
        /// アニメーションの再生タイプです。
        /// </summary>
        [DataModelPropertyGuid("4927aa32-f066-44d4-8923-761ffadd3674")]
        public int LoopMode { get; set; }

        /// <summary>
        /// ループ再生にした際の終端フレームです。
        /// </summary>
        [DataModelPropertyGuid("2f529fe4-7e31-4700-ab9e-0221ba1f31c3")]
        public int LoopEnd { get; set; }

        /// <summary>
        /// 開始位置をランダム化するか否かのフラグです。
        /// </summary>
        [DataModelPropertyGuid("2840fb6a-94db-445f-b37a-609cb14c7128")]
        public int Randomize { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as RandomFe1ParamData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.RandomRange = srcDataModel.RandomRange;
            this.BlankFrames = srcDataModel.BlankFrames;
            this.EnableAnimation = srcDataModel.EnableAnimation;
            this.AnimationTable = srcDataModel.AnimationTable;
            this.LoopMode = srcDataModel.LoopMode;
            this.LoopEnd = srcDataModel.LoopEnd;
            this.Randomize = srcDataModel.Randomize;

            return true;
        }
    }
}
