﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Linq;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// フィールドランダム／基本設定
    /// </summary>
    [Serializable]
    public class RandomBasicSetting : DataModelBase
    {
        /// <summary>
        /// ランダム適用量
        /// </summary>
        private Vector3f randomVel = null;

        /// <summary>
        /// アニメーションテーブル
        /// </summary>
        private AnimationTableData animationTable = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public RandomBasicSetting() :
            base()
        {
            this.RandomVel = new Vector3f(0.0f, 0.0f, 0.0f);
            this.EnableAnimation = 0;
            this.EnableAirRegist = true;
            this.BaseFrequency = 1000;
            this.LoopMode = 0;
            this.LoopEnd = 100;
            this.Randomize = 0;
        }

        /// <summary>
        /// ランダム適用量
        /// </summary>
        [DataModelPropertyGuid("fa047502-ca68-4e12-8972-89b9853499c4")]
        public Vector3f RandomVel
        {
            get { return this.GetObjectFromField(ref this.randomVel, false); }
            set { this.SetISettableToField(ref this.randomVel, value); }
        }

        /// <summary>
        /// パーティクル時間アニメの有無
        /// </summary>
        [DataModelPropertyGuid("3fa94b91-e1b2-434b-b9d3-163c8c7c9be2")]
        public int EnableAnimation { get; set; }

        /// <summary>
        /// 空気抵抗のON/OFF
        /// </summary>
        [DataModelPropertyGuid("85bd3be0-f8ad-41ab-832a-c604e649b505")]
        public bool EnableAirRegist { get; set; }

        /// <summary>
        /// ランダム基本周期
        /// </summary>
        [DataModelPropertyGuid("03fafded-212e-4544-8985-23b8c7ea8302")]
        public int BaseFrequency { get; set; }

        /// <summary>
        /// アニメーションテーブル
        /// </summary>
        [DataModelPropertyGuid("36cfd537-a0f5-4941-b517-058e85f40bfe")]
        public AnimationTableData AnimationTable
        {
            get { return this.GetObjectFromField(ref this.animationTable, false); }
            set { this.SetISettableToField(ref this.animationTable, value); }
        }

        /// <summary>
        /// アニメーションの再生タイプです。
        /// </summary>
        [DataModelPropertyGuid("4a60dd4a-143b-412e-b00f-753c75742c8e")]
        public int LoopMode { get; set; }

        /// <summary>
        /// ループ再生にした際の終端フレームです。
        /// </summary>
        [DataModelPropertyGuid("9759b009-382a-4439-82c2-073fdca8e791")]
        public int LoopEnd { get; set; }

        /// <summary>
        /// 開始位置をランダム化するか否かのフラグです。
        /// </summary>
        [DataModelPropertyGuid("c3b437c0-394a-4bad-961e-e27dd6b194bf")]
        public int Randomize { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as RandomBasicSetting;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.RandomVel = srcDataModel.RandomVel;
            this.EnableAnimation = srcDataModel.EnableAnimation;
            this.EnableAirRegist = srcDataModel.EnableAirRegist;
            this.BaseFrequency = srcDataModel.BaseFrequency;
            this.AnimationTable = srcDataModel.AnimationTable;
            this.LoopMode = srcDataModel.LoopMode;
            this.LoopEnd = srcDataModel.LoopEnd;
            this.Randomize = srcDataModel.Randomize;

            return true;
        }
    }
}
