﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// フィールドノード/磁力データです。
    /// </summary>
    [Serializable]
    public class MagnetParamData : DataModelBase
    {
        /// <summary>
        /// 位置.
        /// </summary>
        private Vector3f magnetPos = null;

        /// <summary>
        /// アニメーションテーブルです。
        /// </summary>
        private AnimationTableData animationTable = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public MagnetParamData() :
            base()
        {
            this.MagnetPower = 0.0f;
            this.MagnetPos = new Vector3f(0.0f, 0.0f, 0.0f);
            this.FollowEmitter = false;
            this.EnableAxisX = true;
            this.EnableAxisY = true;
            this.EnableAxisZ = true;
            this.EnableAnimation = 0;
            this.LoopMode = 0;
            this.LoopEnd = 100;
            this.Randomize = 0;
        }

        /// <summary>
        /// 磁力.
        /// </summary>
        [DataModelPropertyGuid("e4397697-3102-43b5-9579-e258abb4548c")]
        public float MagnetPower { get; set; }

        /// <summary>
        /// 位置.
        /// </summary>
        [DataModelPropertyGuid("54072949-e538-4b36-bdb5-866023c068bd")]
        public Vector3f MagnetPos
        {
            get { return this.GetObjectFromField(ref this.magnetPos, false); }
            set { this.SetISettableToField(ref this.magnetPos, value); }
        }

        /// <summary>
        /// 位置の追従タイプ.
        /// </summary>
        [DataModelPropertyGuid("59047701-6603-4835-95a8-2ea39aa1e759")]
        public bool FollowEmitter { get; set; }

        /// <summary>
        /// 対象座標軸X軸.
        /// </summary>
        [DataModelPropertyGuid("d80f1128-5f61-4fc4-b491-fd671ac803d2")]
        public bool EnableAxisX { get; set; }

        /// <summary>
        /// 対象座標軸Y軸.
        /// </summary>
        [DataModelPropertyGuid("33be7ebe-0785-499a-95f9-378d8af7179d")]
        public bool EnableAxisY { get; set; }

        /// <summary>
        /// 対象座標軸Z軸.
        /// </summary>
        [DataModelPropertyGuid("166e6021-ffab-4340-a104-e02f137ab5b3")]
        public bool EnableAxisZ { get; set; }

        /// <summary>
        /// 磁力のアニメーションの有無を表すフラグです。
        /// </summary>
        [DataModelPropertyGuid("7e55448f-8ccc-436e-9f0c-a2153f7b3271")]
        public int EnableAnimation { get; set; }

        /// <summary>
        /// アニメーションテーブルです。
        /// </summary>
        [DataModelPropertyGuid("a7f08f5d-d451-4429-88b0-88d96b866fb2")]
        public AnimationTableData AnimationTable
        {
            get { return this.GetObjectFromField(ref this.animationTable, false); }
            set { this.SetISettableToField(ref this.animationTable, value); }
        }

        /// <summary>
        /// アニメーションの再生タイプです。
        /// </summary>
        [DataModelPropertyGuid("36b514c8-1068-4905-b3d6-e7a678b502d9")]
        public int LoopMode { get; set; }

        /// <summary>
        /// ループ再生にした際の終端フレームです。
        /// </summary>
        [DataModelPropertyGuid("d79ac03b-61d7-4e46-a3be-a399649cd39b")]
        public int LoopEnd { get; set; }

        /// <summary>
        /// 開始位置をランダム化するか否かのフラグです。
        /// </summary>
        [DataModelPropertyGuid("f48306f8-b601-458e-af8e-9b1a0ebc9fbf")]
        public int Randomize { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as MagnetParamData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.MagnetPower = srcDataModel.MagnetPower;
            this.MagnetPos = srcDataModel.MagnetPos;
            this.FollowEmitter = srcDataModel.FollowEmitter;
            this.EnableAxisX = srcDataModel.EnableAxisX;
            this.EnableAxisY = srcDataModel.EnableAxisY;
            this.EnableAxisZ = srcDataModel.EnableAxisZ;
            this.EnableAnimation = srcDataModel.EnableAnimation;
            this.AnimationTable = srcDataModel.AnimationTable;
            this.LoopMode = srcDataModel.LoopMode;
            this.LoopEnd = srcDataModel.LoopEnd;
            this.Randomize = srcDataModel.Randomize;

            return true;
        }
    }
}
