﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// The data model for magnet field node.
    /// </summary>
    [Serializable]
    public class MagnetData : FieldDataBase
    {
        /// <summary>
        /// The data model for the magnet node, parameter page.
        /// </summary>
        private MagnetParamData magnetParamData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public MagnetData() :
            base()
        {
        }

        /// <summary>
        /// The data model for the magnet node, parameter page.
        /// </summary>
        [DataModelPropertyGuid("5cef68fd-1256-4e1e-a123-63b6f55c2918")]
        public MagnetParamData MagnetParamData
        {
            get { return this.GetDataModelFromField(ref this.magnetParamData, false); }
            set { this.SetDataModelToField(ref this.magnetParamData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as MagnetData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.MagnetParamData = srcDataModel.MagnetParamData;

            return true;
        }
    }
}
