﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// フィールドノード/フィールドタブです。
    /// </summary>
    [Serializable]
    public class ConvergeData : FieldDataBase
    {
        /// <summary>
        /// 収束グループです。
        /// </summary>
        private ConvergeParamData convergeParamData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ConvergeData() :
            base()
        {
        }

        /// <summary>
        /// 収束グループです。
        /// </summary>
        [DataModelPropertyGuid("96b228a4-7477-4c0f-86f4-311d097c27b7")]
        public ConvergeParamData ConvergeParamData
        {
            get { return this.GetDataModelFromField(ref this.convergeParamData, false); }
            set { this.SetDataModelToField(ref this.convergeParamData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as ConvergeData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ConvergeParamData = srcDataModel.ConvergeParamData;

            return true;
        }
    }
}
