﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Linq;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタセットノード/ユーザーデータタブ/数値グループデータです。
    /// </summary>
    [Serializable]
    public class EmitterSetUserValueData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterSetUserValueData() :
            base()
        {
        }

        /// <summary>
        /// 数値1を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("9f4e5ccf-9ff5-4d89-a3f6-0196769f27ae")]
        public uint Value1 { get; set; }

        /// <summary>
        /// 数値2を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("f989e311-e919-4996-a0e8-c952f1524bf1")]
        public uint Value2 { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterSetUserValueData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Value1 = srcDataModel.Value1;
            this.Value2 = srcDataModel.Value2;

            return true;
        }
    }
}
