﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Linq;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタセットノード/ユーザーデータタブデータ.
    /// </summary>
    [Serializable]
    public class EmitterSetUserData : DataModelBase
    {
        /// <summary>
        /// ビットグループデータを取得または設定します。
        /// </summary>
        private EmitterSetUserFlagData emitterSetUserFlagData = null;

        /// <summary>
        /// 数値グループデータを取得または設定します。
        /// </summary>
        private EmitterSetUserValueData emitterSetUserValueData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterSetUserData() :
            base()
        {
        }

        /// <summary>
        /// ビットグループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("7415edcd-64e4-404a-bf2e-cdfdf6dfc787")]
        public EmitterSetUserFlagData EmitterSetUserFlagData
        {
            get { return this.GetDataModelFromField(ref this.emitterSetUserFlagData, false); }
            set { this.SetDataModelToField(ref this.emitterSetUserFlagData, value); }
        }

        /// <summary>
        /// 数値グループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("add43ddc-f814-4579-ba1b-1de66603dbbd")]
        public EmitterSetUserValueData EmitterSetUserValueData
        {
            get { return this.GetDataModelFromField(ref this.emitterSetUserValueData, false); }
            set { this.SetDataModelToField(ref this.emitterSetUserValueData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterSetUserData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EmitterSetUserFlagData = srcDataModel.EmitterSetUserFlagData;
            this.EmitterSetUserValueData = srcDataModel.EmitterSetUserValueData;

            return true;
        }
    }
}
