﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタセットノードデータです。
    /// </summary>
    [Serializable]
    public class EmitterSetData : DataModelBase
    {
        /// <summary>
        /// ファイル管理データです。
        /// </summary>
        private EmitterSetBasicData emitterSetBasicData = null;

        /// <summary>
        /// ユーザーデータ.
        /// </summary>
        private EmitterSetUserData emitterSetUserData = null;

        /// <summary>
        /// エミッタリストを取得または設定します。
        /// </summary>
        private List<EmitterData> emitterList = null;

        /// <summary>
        /// プレビューリストを取得または設定します。
        /// </summary>
        private List<PreviewData> previewList = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterSetData() :
            base()
        {
            this.Name = string.Empty;
            this.FilePath = string.Empty;
            this.Version = "0.0.0.0";
            this.UseXmlDocSerializer = true;
        }

        [XmlAttribute]
        public string Version { get; set; }

        [XmlAttribute]
        public bool UseXmlDocSerializer { get; set; }

        /// <summary>
        /// 名前を取得または設定します。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("0b3a8c4e-2327-4f8d-8384-6139531dd500")]
        public string Name { get; set; }

        /// <summary>
        /// ファイルパスを取得または設定します。
        /// このパスにはファイル名を含みません。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("72c7b81c-a8a7-4a21-997e-9644ec599725")]
        public string FilePath { get; set; }

        /// <summary>
        /// ファイル管理データです。
        /// </summary>
        [DataModelPropertyGuid("99d1cfbe-186d-4f51-9deb-216b3504c40d")]
        public EmitterSetBasicData EmitterSetBasicData
        {
            get { return this.GetDataModelFromField(ref this.emitterSetBasicData, false); }
            set { this.SetDataModelToField(ref this.emitterSetBasicData, value); }
        }

        /// <summary>
        /// ユーザーデータ.
        /// </summary>
        [DataModelPropertyGuid("e3f52400-9117-46db-9f24-d6c86c78fd4c")]
        public EmitterSetUserData EmitterSetUserData
        {
            get { return this.GetDataModelFromField(ref this.emitterSetUserData, false); }
            set { this.SetDataModelToField(ref this.emitterSetUserData, value); }
        }

        /// <summary>
        /// Enumerate the file path of all the textures the child emitters use.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("e7df4bf5-feba-4c9a-9c82-4d5d728bf807")]
        public IEnumerable<string> TexturePaths
        {
            get
            {
                return this.AllChildEmitters.SelectMany(em => em.TexturePaths);
            }
        }

        /// <summary>
        /// Enumerate the file path of all the primitive the child emitters use.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("fc446954-416c-4bff-a162-1cf1e11f2133")]
        public IEnumerable<string> PrimitivePaths
        {
            get
            {
                return this.AllChildEmitters.SelectMany(em => em.PrimitivePaths);
            }
        }

        /// <summary>
        /// Enumerate the index of all the custom shader the child emitters use.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("da99770a-7504-4e4f-9537-690d7fcec013")]
        public IEnumerable<int> CustomShaderIndices
        {
            get
            {
                return this.AllChildEmitters.Select(em => em.CustomShaderIndex);
            }
        }

        /// <summary>
        /// Get all the emitters by performing a recursive search through all the child emitters.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("5d21f6a7-c4ba-4585-bd7e-b52c2062cda6")]
        public IEnumerable<EmitterData> AllChildEmitters
        {
            get
            {
                foreach (EmitterData item in this.EmitterList)
                {
                    yield return item;
                    foreach (EmitterData child in item.AllChildEmitters)
                    {
                        yield return child;
                    }
                }
            }
        }

        /// <summary>
        /// エミッタリストを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("89081083-7ed2-46cf-a2ae-55fc121e0acb")]
        public List<EmitterData> EmitterList
        {
            get { return this.GetDataModelListFromField(ref this.emitterList); }
            set { this.SetDataModelListToField(ref this.emitterList, value); }
        }

        /// <summary>
        /// プレビューリストを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("c1b2a6b9-5d84-4b97-93b0-5eb97f296459")]
        public List<PreviewData> PreviewList
        {
            get { return this.GetDataModelListFromField(ref this.previewList); }
            set { this.SetDataModelListToField(ref this.previewList, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterSetData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Name = srcDataModel.Name;
            this.FilePath = srcDataModel.FilePath;
            this.EmitterSetBasicData = srcDataModel.EmitterSetBasicData;
            this.EmitterSetUserData = srcDataModel.EmitterSetUserData;
            this.EmitterList = srcDataModel.EmitterList;
            this.PreviewList = srcDataModel.PreviewList;

            return true;
        }
    }
}
