﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Collections.Generic;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// The binary header data for emitter set.
    /// </summary>
    [Serializable]
    public class EmitterSetBinaryHeaderData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterSetBinaryHeaderData() :
            base()
        {
        }

        /// <summary>
        /// Get the tag 0 for the binary data.
        /// </summary>
        [DataModelPropertyGuid("54f8a218-7dbb-492e-882e-b444293b5a4f")]
        public byte Tag0
        {
            get
            {
                return (byte)'E';
            }
        }

        /// <summary>
        /// Get the tag 1 for the binary header.
        /// </summary>
        [DataModelPropertyGuid("24e8b85a-a80e-458d-807a-78a9c2cb076e")]
        public byte Tag1
        {
            get
            {
                return (byte)'S';
            }
        }

        /// <summary>
        /// Get the tag 2 of the binary header.
        /// </summary>
        [DataModelPropertyGuid("81709a2c-6ac9-4a7f-9c7f-669f657c9fd6")]
        public byte Tag2
        {
            get
            {
                return (byte)'E';
            }
        }

        /// <summary>
        /// Get the tag 3 for the binary header.
        /// </summary>
        [DataModelPropertyGuid("c4477885-b86c-421b-b702-5d51e097a27f")]
        public byte Tag3
        {
            get
            {
                return (byte)'T';
            }
        }

        /// <summary>
        /// Get the next emitter set. (this property always returns null, for now.)
        /// </summary>
        [DataModelPropertyGuid("65672f30-7b88-430c-a737-77c2e69fb993")]
        public DataModelBase Next
        {
            get
            {
                return null;
            }
        }

        /// <summary>
        /// Get the first child emitter data.
        /// </summary>
        [DataModelPropertyGuid("3e4cc288-3f4c-4867-8ee2-8b787a2a3640")]
        public DataModelBase Child
        {
            get
            {
                var eset = this.Parent as EmitterSetData;
                if (eset == null ||
                    eset.EmitterList.Count <= 0)
                {
                    return null;
                }

                return eset.EmitterList[0];
            }
        }

        /// <summary>
        /// Get the first data model in the sub tree. (null as in emitter set.)
        /// </summary>
        [DataModelPropertyGuid("df0c8a9a-30ea-415f-ba2e-a377aa7e9a7f")]
        public DataModelBase Sub
        {
            get
            {
                return null;
            }
        }

        /// <summary>
        /// Get the offset to the binary data.
        ///
        /// </summary>
        [DataModelPropertyGuid("935c1008-aba2-439b-93e7-b5c85b0f5859")]
        public uint BinaryDataOffset
        {
            get
            {
                // The size of the binary header data.
                return 32;
            }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterSetBinaryHeaderData;
            if (srcDataModel == null)
            {
                return false;
            }


            return true;
        }
    }
}
