﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/テクスチャタブ/テクスチャファイルグループデータです。
    /// </summary>
    [Serializable]
    public class EmitterTextureFileData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterTextureFileData() :
            base()
        {
            this.FilePath = string.Empty;
            this.PatternDivU = 1;
            this.PatternDivV = 1;
            this.WrapTypeU = 0;
            this.WrapTypeV = 0;
            this.RandomInvU = false;
            this.RandomInvV = false;
            this.RepeatCount = 0;
            this.FilterMode = 0;
            this.AvailableMipMapLevel = 15.99f;
            this.MipMapBias = 0.0f;
            this.SphericalMap = false;
        }

        /// <summary>
        /// Get or set the file path of the texture.
        /// </summary>
        [DataModelPropertyGuid("592dc31f-ed3c-4f2b-b100-73e6fbc84159")]
        public string FilePath { get; set; }

        /// <summary>
        /// Get or set the number of horizontal division of the texture.
        /// </summary>
        [DataModelPropertyGuid("701302eb-69aa-4cc9-ad9a-7bb0e6ba98e7")]
        public int PatternDivU { get; set; }

        /// <summary>
        /// Get or set the number of vertical division of the texture.
        /// </summary>
        [DataModelPropertyGuid("a8ffa8a2-3e3f-4059-a787-a63e1e2925a1")]
        public int PatternDivV { get; set; }

        /// <summary>
        /// Get or set the horizontal wrapping mode of the texture.
        /// </summary>
        [DataModelPropertyGuid("3aec6259-dee6-4a34-bf6a-51e5af7ac77f")]
        public int WrapTypeU { get; set; }

        /// <summary>
        /// Get or set the vertical wrapping mode of the texture.
        /// </summary>
        [DataModelPropertyGuid("11f32d42-3add-4b70-a56c-b8bdb1dda0bd")]
        public int WrapTypeV { get; set; }

        /// <summary>
        /// Get or set the flag indicating whether to randomly flip the texture on horizontal direction.
        /// </summary>
        [DataModelPropertyGuid("54106bc9-6043-4768-9f9b-4e2b3df502cd")]
        public bool RandomInvU { get; set; }

        /// <summary>
        /// Get or set the flag indicating whether to randomly flip the texture on vertical direction.
        /// </summary>
        [DataModelPropertyGuid("f5234fc9-f48b-4b23-b501-20061d344d81")]
        public bool RandomInvV { get; set; }

        /// <summary>
        /// Get or set the repeating mode for the texture, vertically and horizontally.
        /// </summary>
        [DataModelPropertyGuid("496e1963-6dbc-42aa-b567-a7edbe4fe727")]
        public int RepeatCount { get; set; }

        /// <summary>
        /// Get or set the filtering mode for the texture.
        /// </summary>
        [DataModelPropertyGuid("6883aa33-6884-45f3-ab00-0b096afb0b19")]
        public int FilterMode { get; set; }

        /// <summary>
        /// Get or set the available mipmap level.
        /// </summary>
        [DataModelPropertyGuid("6348c8d1-df8d-4f75-9f33-25c75193a9fb")]
        public float AvailableMipMapLevel { get; set; }

        /// <summary>
        /// Get or set the mipmap biasing.
        /// </summary>
        [DataModelPropertyGuid("e875d783-a6d3-4445-b8c6-a231b4555638")]
        public float MipMapBias { get; set; }

        /// <summary>
        /// スフィアマップかどうかのフラグです.
        /// </summary>
        [DataModelPropertyGuid("4a71894b-0f60-41b8-a46b-67b04ade9ac7")]
        public bool SphericalMap { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterTextureFileData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.FilePath = srcDataModel.FilePath;
            this.PatternDivU = srcDataModel.PatternDivU;
            this.PatternDivV = srcDataModel.PatternDivV;
            this.WrapTypeU = srcDataModel.WrapTypeU;
            this.WrapTypeV = srcDataModel.WrapTypeV;
            this.RandomInvU = srcDataModel.RandomInvU;
            this.RandomInvV = srcDataModel.RandomInvV;
            this.RepeatCount = srcDataModel.RepeatCount;
            this.FilterMode = srcDataModel.FilterMode;
            this.AvailableMipMapLevel = srcDataModel.AvailableMipMapLevel;
            this.MipMapBias = srcDataModel.MipMapBias;
            this.SphericalMap = srcDataModel.SphericalMap;

            return true;
        }
    }
}
