﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// テクスチャタブデータです.
    /// </summary>
    [Serializable]
    public class EmitterTextureData : DataModelBase
    {
        /// <summary>
        /// テクスチャファイルグループです.
        /// </summary>
        private EmitterTextureFileData emitterTextureFileData = null;

        /// <summary>
        /// テクスチャ座標アニメーショングループです.
        /// </summary>
        private EmitterTextureUvAnimationData emitterTextureUvAnimationData = null;

        /// <summary>
        /// テクスチャパターンアニメーショングループです.
        /// </summary>
        private EmitterTexturePatternAnimationData emitterTexturePatternAnimationData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterTextureData() :
            base()
        {
        }

        /// <summary>
        /// テクスチャファイルグループです.
        /// </summary>
        [DataModelPropertyGuid("cd7c1012-4f48-444a-9874-8cdcde440145")]
        public EmitterTextureFileData EmitterTextureFileData
        {
            get { return this.GetDataModelFromField(ref this.emitterTextureFileData, false); }
            set { this.SetDataModelToField(ref this.emitterTextureFileData, value); }
        }

        /// <summary>
        /// テクスチャ座標アニメーショングループです.
        /// </summary>
        [DataModelPropertyGuid("266ca54e-b779-42d3-abb5-c11b021360b7")]
        public EmitterTextureUvAnimationData EmitterTextureUvAnimationData
        {
            get { return this.GetDataModelFromField(ref this.emitterTextureUvAnimationData, false); }
            set { this.SetDataModelToField(ref this.emitterTextureUvAnimationData, value); }
        }

        /// <summary>
        /// テクスチャパターンアニメーショングループです.
        /// </summary>
        [DataModelPropertyGuid("a0250cc3-69e7-4f38-9bb0-70126df38bed")]
        public EmitterTexturePatternAnimationData EmitterTexturePatternAnimationData
        {
            get { return this.GetDataModelFromField(ref this.emitterTexturePatternAnimationData, false); }
            set { this.SetDataModelToField(ref this.emitterTexturePatternAnimationData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterTextureData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EmitterTextureFileData = srcDataModel.EmitterTextureFileData;
            this.EmitterTextureUvAnimationData = srcDataModel.EmitterTextureUvAnimationData;
            this.EmitterTexturePatternAnimationData = srcDataModel.EmitterTexturePatternAnimationData;

            return true;
        }
    }
}
