﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// スケールタブデータです.
    /// </summary>
    [Serializable]
    public class EmitterScaleData : DataModelBase
    {
        /// <summary>
        /// 基本スケールグループです.
        /// </summary>
        private EmitterScaleBasicData emitterScaleBasicData = null;

        /// <summary>
        /// アニメーショングループです.
        /// </summary>
        private EmitterScaleAdditionalAnimationData emitterScaleAnimationData = null;

        /// <summary>
        /// カーブエディタグループです。
        /// </summary>
        private EmitterScaleAnimationCurveData emitterScaleAnimationCurveData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterScaleData() :
            base()
        {
        }

        /// <summary>
        /// 基本スケールグループです.
        /// </summary>
        [DataModelPropertyGuid("74ae5f08-2811-4691-a876-8442437b23d5")]
        public EmitterScaleBasicData EmitterScaleBasicData
        {
            get { return this.GetDataModelFromField(ref this.emitterScaleBasicData, false); }
            set { this.SetDataModelToField(ref this.emitterScaleBasicData, value); }
        }

        /// <summary>
        /// アニメーショングループです.
        /// </summary>
        [DataModelPropertyGuid("85c22f3c-f206-4be6-996c-76d8afaf3559")]
        public EmitterScaleAdditionalAnimationData EmitterScaleAnimationData
        {
            get { return this.GetDataModelFromField(ref this.emitterScaleAnimationData, false); }
            set { this.SetDataModelToField(ref this.emitterScaleAnimationData, value); }
        }

        /// <summary>
        /// カーブエディタグループです。
        /// </summary>
        [DataModelPropertyGuid("2852f154-33a8-457f-95b5-b68b9dc08387")]
        public EmitterScaleAnimationCurveData EmitterScaleAnimationCurveData
        {
            get { return this.GetDataModelFromField(ref this.emitterScaleAnimationCurveData, false); }
            set { this.SetDataModelToField(ref this.emitterScaleAnimationCurveData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterScaleData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EmitterScaleBasicData = srcDataModel.EmitterScaleBasicData;
            this.EmitterScaleAnimationData = srcDataModel.EmitterScaleAnimationData;
            this.EmitterScaleAnimationCurveData = srcDataModel.EmitterScaleAnimationCurveData;

            return true;
        }
    }
}
