﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/回転タブ/回転軸Yグループデータです。
    /// </summary>
    [Serializable]
    public class EmitterRotationYData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterRotationYData() :
            base()
        {
            this.InitialRotation = 0.0f;
            this.InitialRotationRandom = 0.0f;
            this.EnableRotationRandom = false;
            this.RotationSpeed = 0.0f;
            this.RotationSpeedRandom = 0.0f;
        }

        /// <summary>
        /// 初期回転(Y軸)です.
        /// </summary>
        [DataModelPropertyGuid("2c2a1be3-cad2-4ac7-bf79-06050964c05b")]
        public float InitialRotation { get; set; }

        /// <summary>
        /// 回転のランダム幅(Y軸)です.
        /// </summary>
        [DataModelPropertyGuid("1a226c00-d732-4313-b825-47671e8a04d0")]
        public float InitialRotationRandom { get; set; }

        /// <summary>
        /// 回転方向ランダム(Y軸)です.
        /// </summary>
        [DataModelPropertyGuid("966aa19d-9a98-4691-837b-509702f76fc5")]
        public bool EnableRotationRandom { get; set; }

        /// <summary>
        /// 回転速度(Y軸)です.
        /// </summary>
        [DataModelPropertyGuid("cad0cd41-45ee-4f20-9823-79de97ff95c9")]
        public float RotationSpeed { get; set; }

        /// <summary>
        /// 回転速度のランダム幅(Y軸)です.
        /// </summary>
        [DataModelPropertyGuid("3691a4ea-fa0a-4257-8c39-da933701f0b2")]
        public float RotationSpeedRandom { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterRotationYData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.InitialRotation = srcDataModel.InitialRotation;
            this.InitialRotationRandom = srcDataModel.InitialRotationRandom;
            this.EnableRotationRandom = srcDataModel.EnableRotationRandom;
            this.RotationSpeed = srcDataModel.RotationSpeed;
            this.RotationSpeedRandom = srcDataModel.RotationSpeedRandom;

            return true;
        }
    }
}
