﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/パーティクルタブ/パーティクル設定グループです。
    /// </summary>
    [Serializable]
    public class EmitterParticleShapeData : DataModelBase
    {
        /// <summary>
        /// スケールです.
        /// </summary>
        private Vector2f scale = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterParticleShapeData() :
            base()
        {
            this.ShapeType = 0;
            this.EnableTrimming = false;
            this.ParticleType = 0;
            this.Scale = new Vector2f(0.0f, 0.0f);
            this.CameraOffsetProcessType = 0;
            this.CameraOffsetValue = 0.0f;
            this.PrimitiveFilePath = string.Empty;
            this.PrimitiveScaleZType = 0;
        }

        /// <summary>
        /// 形状です.
        /// </summary>
        [DataModelPropertyGuid("b013818e-bd0e-4e46-aa84-b432528060ed")]
        public int ShapeType { get; set; }

        /// <summary>
        /// トリミングを有効にするかどうかのフラグです.
        /// </summary>
        [DataModelPropertyGuid("b9201b1f-a63a-409d-bd8e-9b1c5168a62a")]
        public bool EnableTrimming { get; set; }

        /// <summary>
        /// パーティクルタイプです.
        /// </summary>
        [DataModelPropertyGuid("42daf081-d3ae-417f-bd6c-83a79036eca7")]
        public int ParticleType { get; set; }

        /// <summary>
        /// スケールです.
        /// </summary>
        [DataModelPropertyGuid("9508dcb1-6f74-43bf-8ede-a4b317a6afab")]
        public Vector2f Scale
        {
            get { return this.GetObjectFromField(ref this.scale, false); }
            set { this.SetISettableToField(ref this.scale, value); }
        }

        /// <summary>
        /// オフセットの処理方法です.
        /// </summary>
        [DataModelPropertyGuid("ae5e9bb8-1804-4d15-8970-8d088f695a1f")]
        public int CameraOffsetProcessType { get; set; }

        /// <summary>
        /// オフセット値です.
        /// </summary>
        [DataModelPropertyGuid("ea5e2784-b797-4cc1-8f19-5291ed8b6e7a")]
        public float CameraOffsetValue { get; set; }

        /// <summary>
        /// プリミティブファイルパスです。
        /// </summary>
        [DataModelPropertyGuid("0e0ad567-ca95-443b-a07a-253afae9ba45")]
        public string PrimitiveFilePath { get; set; }

        /// <summary>
        /// プリミティブスケールZタイプです。
        /// </summary>
        [DataModelPropertyGuid("8ab7e048-cf37-44f7-949c-cbec8971ff04")]
        public int PrimitiveScaleZType { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterParticleShapeData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ShapeType = srcDataModel.ShapeType;
            this.EnableTrimming = srcDataModel.EnableTrimming;
            this.ParticleType = srcDataModel.ParticleType;
            this.Scale = srcDataModel.Scale;
            this.CameraOffsetProcessType = srcDataModel.CameraOffsetProcessType;
            this.CameraOffsetValue = srcDataModel.CameraOffsetValue;
            this.PrimitiveFilePath = srcDataModel.PrimitiveFilePath;
            this.PrimitiveScaleZType = srcDataModel.PrimitiveScaleZType;

            return true;
        }
    }
}
