﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/エミッタタブ/エミッタ設定グループです。
    /// </summary>
    [Serializable]
    public class EmitterEmitterShapeData : DataModelBase
    {
        /// <summary>
        /// エミッタ半径, もしくは辺の長さ.
        /// </summary>
        private Vector3f emitterTypeEmitterRadius = null;

        /// <summary>
        /// スケールサブグループのスケール.
        /// </summary>
        private Vector3f emitterScaleShapeScale = null;

        /// <summary>
        /// 形状のスケールエミッタ時間アニメ
        /// </summary>
        private EmitterAnimationCommonData shapeScaleAnimation = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterEmitterShapeData() :
            base()
        {
            this.EmitterType = 0;
            this.EmitterTypeEmitterRadius = new Vector3f(1.0f, 1.0f, 1.0f);
            this.EmitterShapeLongitudeArcLength = 360.0f;
            this.EmitterShapeLatitudeArcLength = 180.0f;
            this.EmitterShapeStartArc = 0.0f;
            this.EmitterShapeStartArcRandom = false;
            this.EmitterShapeRandomPos = 0.0f;
            this.EmitterShapeHollowRatio = 0.0f;
            this.EmitterShapeArcType = 0;
            this.EmitterShapeLineCenter = 0.0f;
            this.EmitterShapeLineLength = 1.0f;
            this.EmitterShapeEmissionType = 0;
            this.EmitterShapeSphereAxis = 2;
            this.EmitterShapeSphereAndDivisionDivision = 0;
            this.EmitterShapeSphereAndDivision64Division = 0;
            this.EmitterScaleShapeScale = new Vector3f(1.0f, 1.0f, 1.0f);
            this.PrimitiveFilePath = string.Empty;
            this.RandomPosition = 0.0f;
        }

        /// <summary>
        /// エミッタのタイプです.
        /// </summary>
        [DataModelPropertyGuid("57060530-1832-4606-99e3-04b0397a4b62")]
        public int EmitterType { get; set; }

        /// <summary>
        /// エミッタ半径, もしくは辺の長さ.
        /// </summary>
        [DataModelPropertyGuid("b52fbefd-d776-48d1-8f3a-2a443c53a305")]
        public Vector3f EmitterTypeEmitterRadius
        {
            get { return this.GetObjectFromField(ref this.emitterTypeEmitterRadius, false); }
            set { this.SetISettableToField(ref this.emitterTypeEmitterRadius, value); }
        }

        /// <summary>
        /// 「弧の幅（角度）」の値(経度).
        ///
        /// </summary>
        [DataModelPropertyGuid("fb5cca22-e58c-467a-bbd1-51b11527c209")]
        public float EmitterShapeLongitudeArcLength { get; set; }

        /// <summary>
        /// 「弧の幅（角度）」の値(緯度).
        ///
        /// </summary>
        [DataModelPropertyGuid("c835f0b0-d3cf-4cea-bb9c-05cc811b684a")]
        public float EmitterShapeLatitudeArcLength { get; set; }

        /// <summary>
        /// 弧の開始角度.
        /// </summary>
        [DataModelPropertyGuid("6ec1c64a-9826-4c6e-a452-4148ad9666ef")]
        public float EmitterShapeStartArc { get; set; }

        /// <summary>
        /// 弧の開始角度ランダム.
        /// </summary>
        [DataModelPropertyGuid("39dfe493-c5ea-483b-88e0-858265c9025e")]
        public bool EmitterShapeStartArcRandom { get; set; }

        /// <summary>
        /// ランダム角度.
        /// </summary>
        [DataModelPropertyGuid("5adf3683-3bea-4b37-b26c-0f58f7072d9b")]
        public float EmitterShapeRandomPos { get; set; }

        /// <summary>
        /// 空洞率(%).
        /// </summary>
        [DataModelPropertyGuid("8a403650-39a9-4de6-aa46-9b82f608f90f")]
        public float EmitterShapeHollowRatio { get; set; }

        /// <summary>
        /// 弧の開き方.
        /// </summary>
        [DataModelPropertyGuid("b56dbaf4-ec97-47c9-b829-3e1153df2e91")]
        public int EmitterShapeArcType { get; set; }

        /// <summary>
        /// 中心位置.
        /// </summary>
        [DataModelPropertyGuid("96268159-7be2-448b-ad48-8dd00defe4ce")]
        public float EmitterShapeLineCenter { get; set; }

        /// <summary>
        /// 長さ.
        /// </summary>
        [DataModelPropertyGuid("e3ed7182-a103-4b2f-9c5c-bb4b378bad30")]
        public float EmitterShapeLineLength { get; set; }

        /// <summary>
        /// 放出タイプ.
        /// </summary>
        [DataModelPropertyGuid("4eb1daff-7e94-48b6-a65e-dd8f2b8c4d25")]
        public int EmitterShapeEmissionType { get; set; }

        /// <summary>
        /// 球.緯度.軸.
        /// </summary>
        [DataModelPropertyGuid("6e39450e-7854-4754-bb8f-8395123ee931")]
        public int EmitterShapeSphereAxis { get; set; }

        /// <summary>
        /// 球(等分割).分割数.
        /// </summary>
        [DataModelPropertyGuid("8a095826-5248-440b-aadd-2364376b4913")]
        public int EmitterShapeSphereAndDivisionDivision { get; set; }

        /// <summary>
        /// 球(等分割64).分割数.
        /// </summary>
        [DataModelPropertyGuid("0ebecd54-c857-4e56-9dee-da2ad13539a2")]
        public int EmitterShapeSphereAndDivision64Division { get; set; }

        /// <summary>
        /// スケールサブグループのスケール.
        /// </summary>
        [DataModelPropertyGuid("3b128820-5139-4f0d-8117-d0d5f01b8bb7")]
        public Vector3f EmitterScaleShapeScale
        {
            get { return this.GetObjectFromField(ref this.emitterScaleShapeScale, false); }
            set { this.SetISettableToField(ref this.emitterScaleShapeScale, value); }
        }

        /// <summary>
        /// ボリュームプリミティブのファイルパスです。
        /// </summary>
        [DataModelPropertyGuid("d22026c5-73ff-427d-99e2-cb8a17496747")]
        public string PrimitiveFilePath { get; set; }

        /// <summary>
        /// 放出位置ランダム.
        /// </summary>
        [DataModelPropertyGuid("204b115b-2dd2-4c23-9734-332526256643")]
        public float RandomPosition { get; set; }

        /// <summary>
        /// 形状のスケールエミッタ時間アニメ
        /// </summary>
        [DataModelPropertyGuid("22ade12c-c891-4804-85fc-44c7c85af7be")]
        public EmitterAnimationCommonData ShapeScaleAnimation
        {
            get { return this.GetDataModelFromField(ref this.shapeScaleAnimation, false); }
            set { this.SetDataModelToField(ref this.shapeScaleAnimation, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterEmitterShapeData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EmitterType = srcDataModel.EmitterType;
            this.EmitterTypeEmitterRadius = srcDataModel.EmitterTypeEmitterRadius;
            this.EmitterShapeLongitudeArcLength = srcDataModel.EmitterShapeLongitudeArcLength;
            this.EmitterShapeLatitudeArcLength = srcDataModel.EmitterShapeLatitudeArcLength;
            this.EmitterShapeStartArc = srcDataModel.EmitterShapeStartArc;
            this.EmitterShapeStartArcRandom = srcDataModel.EmitterShapeStartArcRandom;
            this.EmitterShapeRandomPos = srcDataModel.EmitterShapeRandomPos;
            this.EmitterShapeHollowRatio = srcDataModel.EmitterShapeHollowRatio;
            this.EmitterShapeArcType = srcDataModel.EmitterShapeArcType;
            this.EmitterShapeLineCenter = srcDataModel.EmitterShapeLineCenter;
            this.EmitterShapeLineLength = srcDataModel.EmitterShapeLineLength;
            this.EmitterShapeEmissionType = srcDataModel.EmitterShapeEmissionType;
            this.EmitterShapeSphereAxis = srcDataModel.EmitterShapeSphereAxis;
            this.EmitterShapeSphereAndDivisionDivision = srcDataModel.EmitterShapeSphereAndDivisionDivision;
            this.EmitterShapeSphereAndDivision64Division = srcDataModel.EmitterShapeSphereAndDivision64Division;
            this.EmitterScaleShapeScale = srcDataModel.EmitterScaleShapeScale;
            this.PrimitiveFilePath = srcDataModel.PrimitiveFilePath;
            this.RandomPosition = srcDataModel.RandomPosition;
            this.ShapeScaleAnimation = srcDataModel.ShapeScaleAnimation;

            return true;
        }
    }
}
