﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/放出タブ/その他運動設定グループデータです。
    /// </summary>
    [Serializable]
    public class EmitterEmissionGravityData : DataModelBase
    {
        /// <summary>
        /// 重力です.
        /// </summary>
        private Vector3f gravityDir = null;

        /// <summary>
        /// 重力のアニメーションデータセットです。
        /// </summary>
        private EmitterAnimationCommonData gravityAnimation = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterEmissionGravityData() :
            base()
        {
            this.EnableWorldCoordinate = false;
            this.GravityVolume = 0.0f;
            this.GravityDir = new Vector3f(0.0f, -1.0f, 0.0f);
            this.VelocityInheritRate = 0.0f;
            this.AirRegist = 1.0f;
            this.MomentumRandom = 0.0f;
        }

        /// <summary>
        /// ワールド座標系で重力を適用するかどうかのフラグです.
        /// </summary>
        [DataModelPropertyGuid("57ba2be1-c49d-4121-9658-b7f0c2f2d6fc")]
        public bool EnableWorldCoordinate { get; set; }

        /// <summary>
        /// 重力の大きさです.
        /// </summary>
        [DataModelPropertyGuid("fd6cf51f-3d47-41ae-ab8e-f0bf1b1760ca")]
        public float GravityVolume { get; set; }

        /// <summary>
        /// 重力です.
        /// </summary>
        [DataModelPropertyGuid("c15a47b8-3599-43c5-9972-9b03a4379851")]
        public Vector3f GravityDir
        {
            get { return this.GetObjectFromField(ref this.gravityDir, false); }
            set { this.SetISettableToField(ref this.gravityDir, value); }
        }

        /// <summary>
        /// 重力のアニメーションデータセットです。
        /// </summary>
        [DataModelPropertyGuid("efcfb732-12e0-4f77-9730-20b3a7e202d1")]
        public EmitterAnimationCommonData GravityAnimation
        {
            get { return this.GetDataModelFromField(ref this.gravityAnimation, false); }
            set { this.SetDataModelToField(ref this.gravityAnimation, value); }
        }

        /// <summary>
        /// エミッタ速度継承率.
        /// </summary>
        [DataModelPropertyGuid("f1aadb6e-ba3c-4bbe-8620-8ed7777d498f")]
        public float VelocityInheritRate { get; set; }

        /// <summary>
        /// 空気抵抗.
        /// </summary>
        [DataModelPropertyGuid("8e207911-a1e0-4a52-b7b3-2163ad92ad55")]
        public float AirRegist { get; set; }

        /// <summary>
        /// 運動量ランダム.
        /// </summary>
        [DataModelPropertyGuid("477d6abf-2696-4139-a8ba-1d2b842f7094")]
        public float MomentumRandom { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterEmissionGravityData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EnableWorldCoordinate = srcDataModel.EnableWorldCoordinate;
            this.GravityVolume = srcDataModel.GravityVolume;
            this.GravityDir = srcDataModel.GravityDir;
            this.GravityAnimation = srcDataModel.GravityAnimation;
            this.VelocityInheritRate = srcDataModel.VelocityInheritRate;
            this.AirRegist = srcDataModel.AirRegist;
            this.MomentumRandom = srcDataModel.MomentumRandom;

            return true;
        }
    }
}
