﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// 放出タブデータです
    /// </summary>
    [Serializable]
    public class EmitterEmissionData : DataModelBase
    {
        /// <summary>
        /// 放出タイミンググループです.
        /// </summary>
        private EmitterEmissionTimingData emitterEmissionTimingData = null;

        /// <summary>
        /// 放出時の位置と初速グループです.
        /// </summary>
        private EmitterEmissionVelocityData emitterEmissionVelocityData = null;

        /// <summary>
        /// その他運動設定グループです.
        /// </summary>
        private EmitterEmissionGravityData emitterEmissionGravityData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterEmissionData() :
            base()
        {
        }

        /// <summary>
        /// 放出タイミンググループです.
        /// </summary>
        [DataModelPropertyGuid("644c5d36-5153-42fb-9d1b-5a3ac123f063")]
        public EmitterEmissionTimingData EmitterEmissionTimingData
        {
            get { return this.GetDataModelFromField(ref this.emitterEmissionTimingData, false); }
            set { this.SetDataModelToField(ref this.emitterEmissionTimingData, value); }
        }

        /// <summary>
        /// 放出時の位置と初速グループです.
        /// </summary>
        [DataModelPropertyGuid("2a7a6bf4-cb34-42d1-8e96-51f1c4f271cc")]
        public EmitterEmissionVelocityData EmitterEmissionVelocityData
        {
            get { return this.GetDataModelFromField(ref this.emitterEmissionVelocityData, false); }
            set { this.SetDataModelToField(ref this.emitterEmissionVelocityData, value); }
        }

        /// <summary>
        /// その他運動設定グループです.
        /// </summary>
        [DataModelPropertyGuid("3941d33e-b559-4e02-b1bf-d8eeac5edb9a")]
        public EmitterEmissionGravityData EmitterEmissionGravityData
        {
            get { return this.GetDataModelFromField(ref this.emitterEmissionGravityData, false); }
            set { this.SetDataModelToField(ref this.emitterEmissionGravityData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterEmissionData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EmitterEmissionTimingData = srcDataModel.EmitterEmissionTimingData;
            this.EmitterEmissionVelocityData = srcDataModel.EmitterEmissionVelocityData;
            this.EmitterEmissionGravityData = srcDataModel.EmitterEmissionGravityData;

            return true;
        }
    }
}
