﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノート/コンバイナタブ/パーティクルシェーダグループです。
    /// </summary>
    [Serializable]
    public class EmitterCombinerShaderData : DataModelBase
    {
        /// <summary>
        /// 屈折/歪みの係数.
        /// </summary>
        private Vector2f coefficient = null;

        /// <summary>
        ///
        /// </summary>
        private AnimationTableData coefficientAnimationTable = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterCombinerShaderData() :
            base()
        {
            this.ShaderType = 0;
            this.Coefficient = new Vector2f(0.0f, 0.0f);
            this.CoefficientAnimationTable = new AnimationTableData(new[] { new AnimationTableData.FrameValuePair(0, 1.0f, 1.0f, 1.0f, 1.0f), new AnimationTableData.FrameValuePair(25, 1.0f, 1.0f, 1.0f, 1.0f), new AnimationTableData.FrameValuePair(75, 1.0f, 1.0f, 1.0f, 1.0f), new AnimationTableData.FrameValuePair(100, 1.0f, 1.0f, 1.0f, 1.0f), });
            this.ParticleApplyAlphaValue = true;
        }

        /// <summary>
        /// シェーダータイプ.
        /// </summary>
        [DataModelPropertyGuid("52df718b-e6e5-4ded-bcfa-53c84db9a3d0")]
        public int ShaderType { get; set; }

        /// <summary>
        /// 屈折/歪みの係数.
        /// </summary>
        [DataModelPropertyGuid("48128336-4a72-423c-b9fe-4b680232f833")]
        public Vector2f Coefficient
        {
            get { return this.GetObjectFromField(ref this.coefficient, false); }
            set { this.SetISettableToField(ref this.coefficient, value); }
        }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("2d76c03e-1aad-4219-865b-4daaf18d6cbc")]
        public AnimationTableData CoefficientAnimationTable
        {
            get { return this.GetObjectFromField(ref this.coefficientAnimationTable, false); }
            set { this.SetISettableToField(ref this.coefficientAnimationTable, value); }
        }

        /// <summary>
        /// アルファ値を反映.
        /// </summary>
        [DataModelPropertyGuid("c0d62625-4540-4f50-a0f0-3fcd3b38946b")]
        public bool ParticleApplyAlphaValue { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterCombinerShaderData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ShaderType = srcDataModel.ShaderType;
            this.Coefficient = srcDataModel.Coefficient;
            this.CoefficientAnimationTable = srcDataModel.CoefficientAnimationTable;
            this.ParticleApplyAlphaValue = srcDataModel.ParticleApplyAlphaValue;

            return true;
        }
    }
}
