﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/コンバイナタブ/カラー・アルファコンバイナグループです。
    /// </summary>
    [Serializable]
    public class EmitterCombinerEquationData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterCombinerEquationData() :
            base()
        {
            this.ColorTexture0BlendType = 0;
            this.ColorTexture0Channel = 0;
            this.ColorTexture1BlendType = 0;
            this.ColorTexture1Channel = 0;
            this.ColorTexture2BlendType = 0;
            this.ColorTexture2Channel = 0;
            this.ColorTextureExpression = 1;
            this.ColorPrimitiveExpression = 0;
            this.ColorPrimitiveChannel = 0;
            this.AlphaTexture0BlendType = 0;
            this.AlphaTexture0Channel = 0;
            this.AlphaTexture1BlendType = 0;
            this.AlphaTexture1Channel = 0;
            this.AlphaTexture2BlendType = 0;
            this.AlphaTexture2Channel = 0;
            this.AlphaPrimitiveExpression = 0;
            this.AlphaPrimitiveChannel = 0;
            this.AlphaExpression = 0;
        }

        /// <summary>
        /// Colorテクスチャ0：演算式.
        /// </summary>
        [DataModelPropertyGuid("4cb131a0-e0c2-46d4-9167-64129b99dcbf")]
        public int ColorTexture0BlendType { get; set; }

        /// <summary>
        /// Colorテクスチャ0：チャンネル.
        /// </summary>
        [DataModelPropertyGuid("2e6117f7-d00c-4831-81a2-259b83dc8915")]
        public int ColorTexture0Channel { get; set; }

        /// <summary>
        /// Colorテクスチャ1：演算式.
        /// </summary>
        [DataModelPropertyGuid("1aef7528-957e-4cbb-a375-42e3a328bfcd")]
        public int ColorTexture1BlendType { get; set; }

        /// <summary>
        /// Colorテクスチャ1：チャンネル.
        /// </summary>
        [DataModelPropertyGuid("0729433e-1152-42d4-a5b2-149100633aa0")]
        public int ColorTexture1Channel { get; set; }

        /// <summary>
        /// Colorテクスチャ2：演算式.
        /// </summary>
        [DataModelPropertyGuid("30adbf8e-e0bd-4009-81b7-fef2188a8c5b")]
        public int ColorTexture2BlendType { get; set; }

        /// <summary>
        /// Colorテクスチャ2：チャンネル.
        /// </summary>
        [DataModelPropertyGuid("96a9b7cc-6740-4e95-8ab9-efbfec66e84a")]
        public int ColorTexture2Channel { get; set; }

        /// <summary>
        /// Color計算式.
        /// </summary>
        [DataModelPropertyGuid("d87d2ee8-3184-406e-98ab-bc5fc105f8fc")]
        public int ColorTextureExpression { get; set; }

        /// <summary>
        /// プリミティブ：演算式.
        /// </summary>
        [DataModelPropertyGuid("dc258f45-eac8-4619-ac0b-d1fb38fe8b2c")]
        public int ColorPrimitiveExpression { get; set; }

        /// <summary>
        /// プリミティブ：チャンネル.
        /// </summary>
        [DataModelPropertyGuid("8f77463e-7436-4fd1-b735-a06c0f6d9a6e")]
        public int ColorPrimitiveChannel { get; set; }

        /// <summary>
        /// Alphaテクスチャ0：演算式.
        /// </summary>
        [DataModelPropertyGuid("0439bdcd-eb51-43a2-8d3e-4a9e38890015")]
        public int AlphaTexture0BlendType { get; set; }

        /// <summary>
        /// Alphaテクスチャ0：チャンネル.
        /// </summary>
        [DataModelPropertyGuid("4c9b0e58-c1c5-4c54-ad89-0d9f48539137")]
        public int AlphaTexture0Channel { get; set; }

        /// <summary>
        /// Alphaテクスチャ1：演算式.
        /// </summary>
        [DataModelPropertyGuid("71424e79-2c84-461b-96da-55e5cd3e4a4f")]
        public int AlphaTexture1BlendType { get; set; }

        /// <summary>
        /// Alphaテクスチャ1：チャンネル.
        /// </summary>
        [DataModelPropertyGuid("25ed6223-edc6-4306-80ec-face7e114406")]
        public int AlphaTexture1Channel { get; set; }

        /// <summary>
        /// Alphaテクスチャ2：演算式.
        /// </summary>
        [DataModelPropertyGuid("b4f57eda-befe-4b19-9ea3-1126eed3a3f3")]
        public int AlphaTexture2BlendType { get; set; }

        /// <summary>
        /// Alphaテクスチャ2：チャンネル.
        /// </summary>
        [DataModelPropertyGuid("f8e38e7c-3a1d-4143-8956-1a0874692130")]
        public int AlphaTexture2Channel { get; set; }

        /// <summary>
        /// Alphaプリミティブ：演算式.
        /// </summary>
        [DataModelPropertyGuid("41a6784d-e2c9-4958-88c1-c62d4aa1519a")]
        public int AlphaPrimitiveExpression { get; set; }

        /// <summary>
        /// アルファプリミティブチャンネルです.
        /// </summary>
        [DataModelPropertyGuid("2be9e502-029d-42e5-9ab3-dea75f219da4")]
        public int AlphaPrimitiveChannel { get; set; }

        /// <summary>
        /// Alpha計算式.
        /// </summary>
        [DataModelPropertyGuid("78e1ac34-28cc-430f-8131-9111687bcfb7")]
        public int AlphaExpression { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterCombinerEquationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ColorTexture0BlendType = srcDataModel.ColorTexture0BlendType;
            this.ColorTexture0Channel = srcDataModel.ColorTexture0Channel;
            this.ColorTexture1BlendType = srcDataModel.ColorTexture1BlendType;
            this.ColorTexture1Channel = srcDataModel.ColorTexture1Channel;
            this.ColorTexture2BlendType = srcDataModel.ColorTexture2BlendType;
            this.ColorTexture2Channel = srcDataModel.ColorTexture2Channel;
            this.ColorTextureExpression = srcDataModel.ColorTextureExpression;
            this.ColorPrimitiveExpression = srcDataModel.ColorPrimitiveExpression;
            this.ColorPrimitiveChannel = srcDataModel.ColorPrimitiveChannel;
            this.AlphaTexture0BlendType = srcDataModel.AlphaTexture0BlendType;
            this.AlphaTexture0Channel = srcDataModel.AlphaTexture0Channel;
            this.AlphaTexture1BlendType = srcDataModel.AlphaTexture1BlendType;
            this.AlphaTexture1Channel = srcDataModel.AlphaTexture1Channel;
            this.AlphaTexture2BlendType = srcDataModel.AlphaTexture2BlendType;
            this.AlphaTexture2Channel = srcDataModel.AlphaTexture2Channel;
            this.AlphaPrimitiveExpression = srcDataModel.AlphaPrimitiveExpression;
            this.AlphaPrimitiveChannel = srcDataModel.AlphaPrimitiveChannel;
            this.AlphaExpression = srcDataModel.AlphaExpression;

            return true;
        }
    }
}
