﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// コンバイナタブデータです.
    /// </summary>
    [Serializable]
    public class EmitterCombinerData : DataModelBase
    {
        /// <summary>
        /// カラー・アルファコンバイナグループです.
        /// </summary>
        private EmitterCombinerEquationData emitterCombinerEquationData = null;

        /// <summary>
        /// シェーダグループです.
        /// </summary>
        private EmitterCombinerShaderData emitterCombinerShaderData = null;

        /// <summary>
        /// Get or set the combiner editor data.
        /// </summary>
        private EmitterCombinerEditorData emitterCombinerEditorData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterCombinerData() :
            base()
        {
        }

        /// <summary>
        /// カラー・アルファコンバイナグループです.
        /// </summary>
        [DataModelPropertyGuid("f38a8132-6877-466e-b36f-b7fe18c199f4")]
        public EmitterCombinerEquationData EmitterCombinerEquationData
        {
            get { return this.GetDataModelFromField(ref this.emitterCombinerEquationData, false); }
            set { this.SetDataModelToField(ref this.emitterCombinerEquationData, value); }
        }

        /// <summary>
        /// シェーダグループです.
        /// </summary>
        [DataModelPropertyGuid("f7958ff3-3af4-43af-9aae-c9c5f70e6db6")]
        public EmitterCombinerShaderData EmitterCombinerShaderData
        {
            get { return this.GetDataModelFromField(ref this.emitterCombinerShaderData, false); }
            set { this.SetDataModelToField(ref this.emitterCombinerShaderData, value); }
        }

        /// <summary>
        /// Get or set the combiner editor data.
        /// </summary>
        [DataModelPropertyGuid("8b48e1f6-560b-4223-8025-f99421ada89d")]
        public EmitterCombinerEditorData EmitterCombinerEditorData
        {
            get { return this.GetDataModelFromField(ref this.emitterCombinerEditorData, false); }
            set { this.SetDataModelToField(ref this.emitterCombinerEditorData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterCombinerData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EmitterCombinerEquationData = srcDataModel.EmitterCombinerEquationData;
            this.EmitterCombinerShaderData = srcDataModel.EmitterCombinerShaderData;
            this.EmitterCombinerEditorData = srcDataModel.EmitterCombinerEditorData;

            return true;
        }
    }
}
