﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.RandomColor;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/カラータブ/カラー・アルファ設定グループデータです。
    /// </summary>
    [Serializable]
    public class EmitterColorSettingsData : DataModelBase
    {
        /// <summary>
        /// カラー0設定.
        /// </summary>
        private ColorRgba color0Value = null;

        /// <summary>
        /// カラー1設定.
        /// </summary>
        private ColorRgba color1Value = null;

        /// <summary>
        /// カラー0のアニメーションデータです。
        /// </summary>
        private AnimationTableData colorAnimation0 = null;

        /// <summary>
        /// カラー1のアニメーションデータです。
        /// </summary>
        private AnimationTableData colorAnimation1 = null;

        /// <summary>
        /// アルファ0のアニメーションデータです。
        /// </summary>
        private AnimationTableData alphaAnimation0 = null;

        /// <summary>
        /// アルファ1のアニメーションデータです。
        /// </summary>
        private AnimationTableData alphaAnimation1 = null;

        /// <summary>
        ///
        /// </summary>
        private EmitterColorSettingsAnimationData colorAnimationLoopData0 = null;

        /// <summary>
        ///
        /// </summary>
        private EmitterColorSettingsAnimationData colorAnimationLoopData1 = null;

        /// <summary>
        ///
        /// </summary>
        private EmitterColorSettingsAnimationData alphaAnimationLoopData0 = null;

        /// <summary>
        ///
        /// </summary>
        private EmitterColorSettingsAnimationData alphaAnimationLoopData1 = null;

        /// <summary>
        /// ランダムカラー0です。
        /// </summary>
        private RandomColorTable randomColor0 = null;

        /// <summary>
        /// ランダムカラー1です。
        /// </summary>
        private RandomColorTable randomColor1 = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterColorSettingsData() :
            base()
        {
            this.Color0BehaviorType = 0;
            this.Color1BehaviorType = 0;
            this.Alpha0BehaviorType = 0;
            this.Alpha1BehaviorType = 0;
            this.Color0Value = new ColorRgba(1.0f, 1.0f, 1.0f, 1.0f);
            this.Color1Value = new ColorRgba(1.0f, 1.0f, 1.0f, 1.0f);
            this.Alpha0Value = 1.0f;
            this.Alpha1Value = 1.0f;
            this.ColorAnimation0 = new AnimationTableData(0, 1.0f, 1.0f, 1.0f, 1.0f);
            this.ColorAnimation1 = new AnimationTableData(0, 1.0f, 1.0f, 1.0f, 1.0f);
            this.AlphaAnimation0 = new AnimationTableData(0, 1.0f, 1.0f, 1.0f, 1.0f);
            this.AlphaAnimation1 = new AnimationTableData(0, 1.0f, 1.0f, 1.0f, 1.0f);
        }

        /// <summary>
        /// カラー0挙動タイプ.
        /// </summary>
        [DataModelPropertyGuid("3044c1e9-782d-4fa2-aa98-ffb8cc3c656f")]
        public int Color0BehaviorType { get; set; }

        /// <summary>
        /// カラー1挙動タイプ.
        /// </summary>
        [DataModelPropertyGuid("47c9193c-6eb9-4aa9-9cec-eec7b8382e2b")]
        public int Color1BehaviorType { get; set; }

        /// <summary>
        /// アルファ0挙動タイプ.
        /// </summary>
        [DataModelPropertyGuid("b39effb8-2f0a-4e8e-b4ec-a470c69a0744")]
        public int Alpha0BehaviorType { get; set; }

        /// <summary>
        /// アルファ1挙動タイプ.
        /// </summary>
        [DataModelPropertyGuid("f12811ab-1b1b-4098-a12a-eaa9cd995abf")]
        public int Alpha1BehaviorType { get; set; }

        /// <summary>
        /// カラー0設定.
        /// </summary>
        [DataModelPropertyGuid("ed2c40c6-bb31-4913-8f94-0a05a7544990")]
        public ColorRgba Color0Value
        {
            get { return this.GetObjectFromField(ref this.color0Value, false); }
            set { this.SetISettableToField(ref this.color0Value, value); }
        }

        /// <summary>
        /// カラー1設定.
        /// </summary>
        [DataModelPropertyGuid("bc97b7bd-9974-4d96-866f-809a4f20d09e")]
        public ColorRgba Color1Value
        {
            get { return this.GetObjectFromField(ref this.color1Value, false); }
            set { this.SetISettableToField(ref this.color1Value, value); }
        }

        /// <summary>
        /// アルファ0設定.
        /// </summary>
        [DataModelPropertyGuid("908ade7c-5a25-4aec-8831-ba766363ec3e")]
        public float Alpha0Value { get; set; }

        /// <summary>
        /// アルファ1設定.
        /// </summary>
        [DataModelPropertyGuid("0033ef5f-a0cd-46b6-a88a-089958aa718e")]
        public float Alpha1Value { get; set; }

        /// <summary>
        /// カラー0のアニメーションデータです。
        /// </summary>
        [DataModelPropertyGuid("c3ec057b-ef8d-44f9-9675-3b5383bb6acd")]
        public AnimationTableData ColorAnimation0
        {
            get { return this.GetObjectFromField(ref this.colorAnimation0, false); }
            set { this.SetISettableToField(ref this.colorAnimation0, value); }
        }

        /// <summary>
        /// カラー1のアニメーションデータです。
        /// </summary>
        [DataModelPropertyGuid("0c155e74-73f4-46ba-aca7-0af4ef27320d")]
        public AnimationTableData ColorAnimation1
        {
            get { return this.GetObjectFromField(ref this.colorAnimation1, false); }
            set { this.SetISettableToField(ref this.colorAnimation1, value); }
        }

        /// <summary>
        /// アルファ0のアニメーションデータです。
        /// </summary>
        [DataModelPropertyGuid("af62b763-00ec-4582-bbf3-99b06aacef10")]
        public AnimationTableData AlphaAnimation0
        {
            get { return this.GetObjectFromField(ref this.alphaAnimation0, false); }
            set { this.SetISettableToField(ref this.alphaAnimation0, value); }
        }

        /// <summary>
        /// アルファ1のアニメーションデータです。
        /// </summary>
        [DataModelPropertyGuid("6d8a08e1-9624-48d3-b78e-27f95989a442")]
        public AnimationTableData AlphaAnimation1
        {
            get { return this.GetObjectFromField(ref this.alphaAnimation1, false); }
            set { this.SetISettableToField(ref this.alphaAnimation1, value); }
        }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("f601cb40-58e8-42b8-b355-c1a10836ed16")]
        public EmitterColorSettingsAnimationData ColorAnimationLoopData0
        {
            get { return this.GetDataModelFromField(ref this.colorAnimationLoopData0, false); }
            set { this.SetDataModelToField(ref this.colorAnimationLoopData0, value); }
        }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("e925f436-10c0-409e-9e11-8a2439d345cd")]
        public EmitterColorSettingsAnimationData ColorAnimationLoopData1
        {
            get { return this.GetDataModelFromField(ref this.colorAnimationLoopData1, false); }
            set { this.SetDataModelToField(ref this.colorAnimationLoopData1, value); }
        }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("db2902a2-a34b-4979-bb03-ef18d8c1312b")]
        public EmitterColorSettingsAnimationData AlphaAnimationLoopData0
        {
            get { return this.GetDataModelFromField(ref this.alphaAnimationLoopData0, false); }
            set { this.SetDataModelToField(ref this.alphaAnimationLoopData0, value); }
        }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("d15e8893-d0b7-4b1c-a876-0ef0a56a9e1a")]
        public EmitterColorSettingsAnimationData AlphaAnimationLoopData1
        {
            get { return this.GetDataModelFromField(ref this.alphaAnimationLoopData1, false); }
            set { this.SetDataModelToField(ref this.alphaAnimationLoopData1, value); }
        }

        /// <summary>
        /// ランダムカラー0です。
        /// </summary>
        [DataModelPropertyGuid("92953cca-f2d8-4289-97e6-23646e681827")]
        public RandomColorTable RandomColor0
        {
            get { return this.GetObjectFromField(ref this.randomColor0, false); }
            set { this.SetISettableToField(ref this.randomColor0, value); }
        }

        /// <summary>
        /// ランダムカラー1です。
        /// </summary>
        [DataModelPropertyGuid("3bb877f8-9a60-4a72-af14-ccb8abac1cbf")]
        public RandomColorTable RandomColor1
        {
            get { return this.GetObjectFromField(ref this.randomColor1, false); }
            set { this.SetISettableToField(ref this.randomColor1, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterColorSettingsData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Color0BehaviorType = srcDataModel.Color0BehaviorType;
            this.Color1BehaviorType = srcDataModel.Color1BehaviorType;
            this.Alpha0BehaviorType = srcDataModel.Alpha0BehaviorType;
            this.Alpha1BehaviorType = srcDataModel.Alpha1BehaviorType;
            this.Color0Value = srcDataModel.Color0Value;
            this.Color1Value = srcDataModel.Color1Value;
            this.Alpha0Value = srcDataModel.Alpha0Value;
            this.Alpha1Value = srcDataModel.Alpha1Value;
            this.ColorAnimation0 = srcDataModel.ColorAnimation0;
            this.ColorAnimation1 = srcDataModel.ColorAnimation1;
            this.AlphaAnimation0 = srcDataModel.AlphaAnimation0;
            this.AlphaAnimation1 = srcDataModel.AlphaAnimation1;
            this.ColorAnimationLoopData0 = srcDataModel.ColorAnimationLoopData0;
            this.ColorAnimationLoopData1 = srcDataModel.ColorAnimationLoopData1;
            this.AlphaAnimationLoopData0 = srcDataModel.AlphaAnimationLoopData0;
            this.AlphaAnimationLoopData1 = srcDataModel.AlphaAnimationLoopData1;
            this.RandomColor0 = srcDataModel.RandomColor0;
            this.RandomColor1 = srcDataModel.RandomColor1;

            return true;
        }
    }
}
