﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// カラータブです。
    /// </summary>
    [Serializable]
    public class EmitterColorGroupData : DataModelBase
    {
        /// <summary>
        /// パティ—クルサブタブです。
        /// </summary>
        private EmitterColorData particleColor = null;

        /// <summary>
        /// グローバルサブタブデータです.
        /// </summary>
        private EmitterEmitterColorData emitterColor = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterColorGroupData() :
            base()
        {
        }

        /// <summary>
        /// パティ—クルサブタブです。
        /// </summary>
        [DataModelPropertyGuid("cbe83dba-7137-4897-8f35-ae0eafb95bd1")]
        public EmitterColorData ParticleColor
        {
            get { return this.GetDataModelFromField(ref this.particleColor, false); }
            set { this.SetDataModelToField(ref this.particleColor, value); }
        }

        /// <summary>
        /// グローバルサブタブデータです.
        /// </summary>
        [DataModelPropertyGuid("28ce8f05-56ed-456f-93e8-9ce1f6749119")]
        public EmitterEmitterColorData EmitterColor
        {
            get { return this.GetDataModelFromField(ref this.emitterColor, false); }
            set { this.SetDataModelToField(ref this.emitterColor, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterColorGroupData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ParticleColor = srcDataModel.ParticleColor;
            this.EmitterColor = srcDataModel.EmitterColor;

            return true;
        }
    }
}
